@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationVaultArn An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
 * @property lifecycle The lifecycle defines when a protected resource is copied over to a backup vault and when it expires.  Fields documented above.
 */
public data class PlanRuleCopyAction(
    public val destinationVaultArn: String,
    public val lifecycle: PlanRuleCopyActionLifecycle? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.PlanRuleCopyAction): PlanRuleCopyAction = PlanRuleCopyAction(
            destinationVaultArn = javaType.destinationVaultArn(),
            lifecycle = javaType.lifecycle().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.PlanRuleCopyActionLifecycle.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
