@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property coldStorageAfter Specifies the number of days after creation that a recovery point is moved to cold storage.
 * @property deleteAfter Specifies the number of days after creation that a recovery point is deleted. Must be 90 days greater than `cold_storage_after`.
 * @property optInToArchiveForSupportedResources This setting will instruct your backup plan to transition supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
 */
public data class PlanRuleLifecycle(
    public val coldStorageAfter: Int? = null,
    public val deleteAfter: Int? = null,
    public val optInToArchiveForSupportedResources: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.PlanRuleLifecycle): PlanRuleLifecycle = PlanRuleLifecycle(
            coldStorageAfter = javaType.coldStorageAfter().map({ args0 -> args0 }).orElse(null),
            deleteAfter = javaType.deleteAfter().map({ args0 -> args0 }).orElse(null),
            optInToArchiveForSupportedResources = javaType.optInToArchiveForSupportedResources().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
