@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property stringEquals
 * @property stringLikes
 * @property stringNotEquals
 * @property stringNotLikes
 */
public data class SelectionCondition(
    public val stringEquals: List<SelectionConditionStringEqual>? = null,
    public val stringLikes: List<SelectionConditionStringLike>? = null,
    public val stringNotEquals: List<SelectionConditionStringNotEqual>? = null,
    public val stringNotLikes: List<SelectionConditionStringNotLike>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.SelectionCondition): SelectionCondition = SelectionCondition(
            stringEquals = javaType.stringEquals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.SelectionConditionStringEqual.Companion.toKotlin(args0)
                })
            }),
            stringLikes = javaType.stringLikes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.SelectionConditionStringLike.Companion.toKotlin(args0)
                })
            }),
            stringNotEquals = javaType.stringNotEquals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.SelectionConditionStringNotEqual.Companion.toKotlin(args0)
                })
            }),
            stringNotLikes = javaType.stringNotLikes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.SelectionConditionStringNotLike.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
