@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key The key in a key-value pair.
 * @property type An operation, such as `StringEquals`, that is applied to a key-value pair used to filter resources in a selection.
 * @property value The value in a key-value pair.
 */
public data class SelectionSelectionTag(
    public val key: String,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.SelectionSelectionTag): SelectionSelectionTag = SelectionSelectionTag(
            key = javaType.key(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
