@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.BatchFunctions.getComputeEnvironmentPlain
import com.pulumi.aws.batch.BatchFunctions.getJobDefinitionPlain
import com.pulumi.aws.batch.BatchFunctions.getJobQueuePlain
import com.pulumi.aws.batch.BatchFunctions.getSchedulingPolicyPlain
import com.pulumi.aws.batch.kotlin.inputs.GetComputeEnvironmentPlainArgs
import com.pulumi.aws.batch.kotlin.inputs.GetComputeEnvironmentPlainArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.GetJobDefinitionPlainArgs
import com.pulumi.aws.batch.kotlin.inputs.GetJobDefinitionPlainArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.GetJobQueuePlainArgs
import com.pulumi.aws.batch.kotlin.inputs.GetJobQueuePlainArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.GetSchedulingPolicyPlainArgs
import com.pulumi.aws.batch.kotlin.inputs.GetSchedulingPolicyPlainArgsBuilder
import com.pulumi.aws.batch.kotlin.outputs.GetComputeEnvironmentResult
import com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionResult
import com.pulumi.aws.batch.kotlin.outputs.GetJobQueueResult
import com.pulumi.aws.batch.kotlin.outputs.GetSchedulingPolicyResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.batch.kotlin.outputs.GetComputeEnvironmentResult.Companion.toKotlin as getComputeEnvironmentResultToKotlin
import com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionResult.Companion.toKotlin as getJobDefinitionResultToKotlin
import com.pulumi.aws.batch.kotlin.outputs.GetJobQueueResult.Companion.toKotlin as getJobQueueResultToKotlin
import com.pulumi.aws.batch.kotlin.outputs.GetSchedulingPolicyResult.Companion.toKotlin as getSchedulingPolicyResultToKotlin

public object BatchFunctions {
    /**
     * The Batch Compute Environment data source allows access to details of a specific
     * compute environment within AWS Batch.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const batch-mongo = aws.batch.getComputeEnvironment({
     *     computeEnvironmentName: "batch-mongo-production",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * batch_mongo = aws.batch.get_compute_environment(compute_environment_name="batch-mongo-production")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var batch_mongo = Aws.Batch.GetComputeEnvironment.Invoke(new()
     *     {
     *         ComputeEnvironmentName = "batch-mongo-production",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := batch.LookupComputeEnvironment(ctx, &batch.LookupComputeEnvironmentArgs{
     * 			ComputeEnvironmentName: "batch-mongo-production",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetComputeEnvironmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var batch-mongo = BatchFunctions.getComputeEnvironment(GetComputeEnvironmentArgs.builder()
     *             .computeEnvironmentName("batch-mongo-production")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   batch-mongo:
     *     fn::invoke:
     *       Function: aws:batch:getComputeEnvironment
     *       Arguments:
     *         computeEnvironmentName: batch-mongo-production
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getComputeEnvironment.
     * @return A collection of values returned by getComputeEnvironment.
     */
    public suspend fun getComputeEnvironment(argument: GetComputeEnvironmentPlainArgs): GetComputeEnvironmentResult =
        getComputeEnvironmentResultToKotlin(getComputeEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getComputeEnvironment].
     * @param computeEnvironmentName Name of the Batch Compute Environment
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getComputeEnvironment.
     */
    public suspend fun getComputeEnvironment(
        computeEnvironmentName: String,
        tags: Map<String, String>? = null,
    ): GetComputeEnvironmentResult {
        val argument = GetComputeEnvironmentPlainArgs(
            computeEnvironmentName = computeEnvironmentName,
            tags = tags,
        )
        return getComputeEnvironmentResultToKotlin(getComputeEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getComputeEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;batch&#46;kotlin&#46;inputs&#46;GetComputeEnvironmentPlainArgs].
     * @return A collection of values returned by getComputeEnvironment.
     */
    public suspend fun getComputeEnvironment(argument: suspend GetComputeEnvironmentPlainArgsBuilder.() -> Unit): GetComputeEnvironmentResult {
        val builder = GetComputeEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComputeEnvironmentResultToKotlin(getComputeEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Batch Job Definition.
     * ## Example Usage
     * ### Lookup via Arn
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const arn = aws.batch.getJobDefinition({
     *     arn: "arn:aws:batch:us-east-1:012345678910:job-definition/example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * arn = aws.batch.get_job_definition(arn="arn:aws:batch:us-east-1:012345678910:job-definition/example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var arn = Aws.Batch.GetJobDefinition.Invoke(new()
     *     {
     *         Arn = "arn:aws:batch:us-east-1:012345678910:job-definition/example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := batch.LookupJobDefinition(ctx, &batch.LookupJobDefinitionArgs{
     * 			Arn: pulumi.StringRef("arn:aws:batch:us-east-1:012345678910:job-definition/example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetJobDefinitionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var arn = BatchFunctions.getJobDefinition(GetJobDefinitionArgs.builder()
     *             .arn("arn:aws:batch:us-east-1:012345678910:job-definition/example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   arn:
     *     fn::invoke:
     *       Function: aws:batch:getJobDefinition
     *       Arguments:
     *         arn: arn:aws:batch:us-east-1:012345678910:job-definition/example
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Lookup via Name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const name = aws.batch.getJobDefinition({
     *     name: "example",
     *     revision: 2,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * name = aws.batch.get_job_definition(name="example",
     *     revision=2)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var name = Aws.Batch.GetJobDefinition.Invoke(new()
     *     {
     *         Name = "example",
     *         Revision = 2,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := batch.LookupJobDefinition(ctx, &batch.LookupJobDefinitionArgs{
     * 			Name:     pulumi.StringRef("example"),
     * 			Revision: pulumi.IntRef(2),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetJobDefinitionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var name = BatchFunctions.getJobDefinition(GetJobDefinitionArgs.builder()
     *             .name("example")
     *             .revision(2)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   name:
     *     fn::invoke:
     *       Function: aws:batch:getJobDefinition
     *       Arguments:
     *         name: example
     *         revision: 2
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getJobDefinition.
     * @return A collection of values returned by getJobDefinition.
     */
    public suspend fun getJobDefinition(argument: GetJobDefinitionPlainArgs): GetJobDefinitionResult =
        getJobDefinitionResultToKotlin(getJobDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getJobDefinition].
     * @param arn ARN of the Job Definition. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
     * @param name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     * @param revision The revision of the job definition.
     * @param status The status of the job definition.
     * @return A collection of values returned by getJobDefinition.
     */
    public suspend fun getJobDefinition(
        arn: String? = null,
        name: String? = null,
        revision: Int? = null,
        status: String? = null,
    ): GetJobDefinitionResult {
        val argument = GetJobDefinitionPlainArgs(
            arn = arn,
            name = name,
            revision = revision,
            status = status,
        )
        return getJobDefinitionResultToKotlin(getJobDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;batch&#46;kotlin&#46;inputs&#46;GetJobDefinitionPlainArgs].
     * @return A collection of values returned by getJobDefinition.
     */
    public suspend fun getJobDefinition(argument: suspend GetJobDefinitionPlainArgsBuilder.() -> Unit): GetJobDefinitionResult {
        val builder = GetJobDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobDefinitionResultToKotlin(getJobDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * The Batch Job Queue data source allows access to details of a specific
     * job queue within AWS Batch.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test-queue = aws.batch.getJobQueue({
     *     name: "tf-test-batch-job-queue",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test_queue = aws.batch.get_job_queue(name="tf-test-batch-job-queue")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test_queue = Aws.Batch.GetJobQueue.Invoke(new()
     *     {
     *         Name = "tf-test-batch-job-queue",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := batch.LookupJobQueue(ctx, &batch.LookupJobQueueArgs{
     * 			Name: "tf-test-batch-job-queue",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetJobQueueArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test-queue = BatchFunctions.getJobQueue(GetJobQueueArgs.builder()
     *             .name("tf-test-batch-job-queue")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test-queue:
     *     fn::invoke:
     *       Function: aws:batch:getJobQueue
     *       Arguments:
     *         name: tf-test-batch-job-queue
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getJobQueue.
     * @return A collection of values returned by getJobQueue.
     */
    public suspend fun getJobQueue(argument: GetJobQueuePlainArgs): GetJobQueueResult =
        getJobQueueResultToKotlin(getJobQueuePlain(argument.toJava()).await())

    /**
     * @see [getJobQueue].
     * @param name Name of the job queue.
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getJobQueue.
     */
    public suspend fun getJobQueue(name: String, tags: Map<String, String>? = null): GetJobQueueResult {
        val argument = GetJobQueuePlainArgs(
            name = name,
            tags = tags,
        )
        return getJobQueueResultToKotlin(getJobQueuePlain(argument.toJava()).await())
    }

    /**
     * @see [getJobQueue].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;batch&#46;kotlin&#46;inputs&#46;GetJobQueuePlainArgs].
     * @return A collection of values returned by getJobQueue.
     */
    public suspend fun getJobQueue(argument: suspend GetJobQueuePlainArgsBuilder.() -> Unit): GetJobQueueResult {
        val builder = GetJobQueuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobQueueResultToKotlin(getJobQueuePlain(builtArgument.toJava()).await())
    }

    /**
     * The Batch Scheduling Policy data source allows access to details of a specific Scheduling Policy within AWS Batch.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.batch.getSchedulingPolicy({
     *     arn: "arn:aws:batch:us-east-1:012345678910:scheduling-policy/example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.batch.get_scheduling_policy(arn="arn:aws:batch:us-east-1:012345678910:scheduling-policy/example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Batch.GetSchedulingPolicy.Invoke(new()
     *     {
     *         Arn = "arn:aws:batch:us-east-1:012345678910:scheduling-policy/example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := batch.LookupSchedulingPolicy(ctx, &batch.LookupSchedulingPolicyArgs{
     * 			Arn: "arn:aws:batch:us-east-1:012345678910:scheduling-policy/example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetSchedulingPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BatchFunctions.getSchedulingPolicy(GetSchedulingPolicyArgs.builder()
     *             .arn("arn:aws:batch:us-east-1:012345678910:scheduling-policy/example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:batch:getSchedulingPolicy
     *       Arguments:
     *         arn: arn:aws:batch:us-east-1:012345678910:scheduling-policy/example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSchedulingPolicy.
     * @return A collection of values returned by getSchedulingPolicy.
     */
    public suspend fun getSchedulingPolicy(argument: GetSchedulingPolicyPlainArgs): GetSchedulingPolicyResult =
        getSchedulingPolicyResultToKotlin(getSchedulingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getSchedulingPolicy].
     * @param arn ARN of the scheduling policy.
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getSchedulingPolicy.
     */
    public suspend fun getSchedulingPolicy(arn: String, tags: Map<String, String>? = null): GetSchedulingPolicyResult {
        val argument = GetSchedulingPolicyPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getSchedulingPolicyResultToKotlin(getSchedulingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedulingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;batch&#46;kotlin&#46;inputs&#46;GetSchedulingPolicyPlainArgs].
     * @return A collection of values returned by getSchedulingPolicy.
     */
    public suspend fun getSchedulingPolicy(argument: suspend GetSchedulingPolicyPlainArgsBuilder.() -> Unit): GetSchedulingPolicyResult {
        val builder = GetSchedulingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSchedulingPolicyResultToKotlin(getSchedulingPolicyPlain(builtArgument.toJava()).await())
    }
}
