@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.kotlin.outputs.JobQueueComputeEnvironmentOrder
import com.pulumi.aws.batch.kotlin.outputs.JobQueueTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.batch.kotlin.outputs.JobQueueComputeEnvironmentOrder.Companion.toKotlin as jobQueueComputeEnvironmentOrderToKotlin
import com.pulumi.aws.batch.kotlin.outputs.JobQueueTimeouts.Companion.toKotlin as jobQueueTimeoutsToKotlin

/**
 * Builder for [JobQueue].
 */
@PulumiTagMarker
public class JobQueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobQueueArgs = JobQueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobQueueArgsBuilder.() -> Unit) {
        val builder = JobQueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobQueue {
        val builtJavaResource = com.pulumi.aws.batch.JobQueue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobQueue(builtJavaResource)
    }
}

/**
 * Provides a Batch Job Queue resource.
 * ## Example Usage
 * ### Basic Job Queue
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testQueue = new aws.batch.JobQueue("test_queue", {
 *     name: "tf-test-batch-job-queue",
 *     state: "ENABLED",
 *     priority: 1,
 *     computeEnvironmentOrders: [
 *         {
 *             order: 1,
 *             computeEnvironment: testEnvironment1.arn,
 *         },
 *         {
 *             order: 2,
 *             computeEnvironment: testEnvironment2.arn,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_queue = aws.batch.JobQueue("test_queue",
 *     name="tf-test-batch-job-queue",
 *     state="ENABLED",
 *     priority=1,
 *     compute_environment_orders=[
 *         {
 *             "order": 1,
 *             "compute_environment": test_environment1["arn"],
 *         },
 *         {
 *             "order": 2,
 *             "compute_environment": test_environment2["arn"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testQueue = new Aws.Batch.JobQueue("test_queue", new()
 *     {
 *         Name = "tf-test-batch-job-queue",
 *         State = "ENABLED",
 *         Priority = 1,
 *         ComputeEnvironmentOrders = new[]
 *         {
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 1,
 *                 ComputeEnvironment = testEnvironment1.Arn,
 *             },
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 2,
 *                 ComputeEnvironment = testEnvironment2.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewJobQueue(ctx, "test_queue", &batch.JobQueueArgs{
 * 			Name:     pulumi.String("tf-test-batch-job-queue"),
 * 			State:    pulumi.String("ENABLED"),
 * 			Priority: pulumi.Int(1),
 * 			ComputeEnvironmentOrders: batch.JobQueueComputeEnvironmentOrderArray{
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(1),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment1.Arn),
 * 				},
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(2),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment2.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testQueue = new JobQueue("testQueue", JobQueueArgs.builder()
 *             .name("tf-test-batch-job-queue")
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironmentOrders(
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(1)
 *                     .computeEnvironment(testEnvironment1.arn())
 *                     .build(),
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(2)
 *                     .computeEnvironment(testEnvironment2.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testQueue:
 *     type: aws:batch:JobQueue
 *     name: test_queue
 *     properties:
 *       name: tf-test-batch-job-queue
 *       state: ENABLED
 *       priority: 1
 *       computeEnvironmentOrders:
 *         - order: 1
 *           computeEnvironment: ${testEnvironment1.arn}
 *         - order: 2
 *           computeEnvironment: ${testEnvironment2.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Job Queue with a fair share scheduling policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.batch.SchedulingPolicy("example", {
 *     name: "example",
 *     fairSharePolicy: {
 *         computeReservation: 1,
 *         shareDecaySeconds: 3600,
 *         shareDistributions: [{
 *             shareIdentifier: "A1*",
 *             weightFactor: 0.1,
 *         }],
 *     },
 * });
 * const exampleJobQueue = new aws.batch.JobQueue("example", {
 *     name: "tf-test-batch-job-queue",
 *     schedulingPolicyArn: example.arn,
 *     state: "ENABLED",
 *     priority: 1,
 *     computeEnvironmentOrders: [
 *         {
 *             order: 1,
 *             computeEnvironment: testEnvironment1.arn,
 *         },
 *         {
 *             order: 2,
 *             computeEnvironment: testEnvironment2.arn,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.batch.SchedulingPolicy("example",
 *     name="example",
 *     fair_share_policy={
 *         "compute_reservation": 1,
 *         "share_decay_seconds": 3600,
 *         "share_distributions": [{
 *             "share_identifier": "A1*",
 *             "weight_factor": 0.1,
 *         }],
 *     })
 * example_job_queue = aws.batch.JobQueue("example",
 *     name="tf-test-batch-job-queue",
 *     scheduling_policy_arn=example.arn,
 *     state="ENABLED",
 *     priority=1,
 *     compute_environment_orders=[
 *         {
 *             "order": 1,
 *             "compute_environment": test_environment1["arn"],
 *         },
 *         {
 *             "order": 2,
 *             "compute_environment": test_environment2["arn"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Batch.SchedulingPolicy("example", new()
 *     {
 *         Name = "example",
 *         FairSharePolicy = new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyArgs
 *         {
 *             ComputeReservation = 1,
 *             ShareDecaySeconds = 3600,
 *             ShareDistributions = new[]
 *             {
 *                 new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs
 *                 {
 *                     ShareIdentifier = "A1*",
 *                     WeightFactor = 0.1,
 *                 },
 *             },
 *         },
 *     });
 *     var exampleJobQueue = new Aws.Batch.JobQueue("example", new()
 *     {
 *         Name = "tf-test-batch-job-queue",
 *         SchedulingPolicyArn = example.Arn,
 *         State = "ENABLED",
 *         Priority = 1,
 *         ComputeEnvironmentOrders = new[]
 *         {
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 1,
 *                 ComputeEnvironment = testEnvironment1.Arn,
 *             },
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 2,
 *                 ComputeEnvironment = testEnvironment2.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := batch.NewSchedulingPolicy(ctx, "example", &batch.SchedulingPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FairSharePolicy: &batch.SchedulingPolicyFairSharePolicyArgs{
 * 				ComputeReservation: pulumi.Int(1),
 * 				ShareDecaySeconds:  pulumi.Int(3600),
 * 				ShareDistributions: batch.SchedulingPolicyFairSharePolicyShareDistributionArray{
 * 					&batch.SchedulingPolicyFairSharePolicyShareDistributionArgs{
 * 						ShareIdentifier: pulumi.String("A1*"),
 * 						WeightFactor:    pulumi.Float64(0.1),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = batch.NewJobQueue(ctx, "example", &batch.JobQueueArgs{
 * 			Name:                pulumi.String("tf-test-batch-job-queue"),
 * 			SchedulingPolicyArn: example.Arn,
 * 			State:               pulumi.String("ENABLED"),
 * 			Priority:            pulumi.Int(1),
 * 			ComputeEnvironmentOrders: batch.JobQueueComputeEnvironmentOrderArray{
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(1),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment1.Arn),
 * 				},
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(2),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment2.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.SchedulingPolicy;
 * import com.pulumi.aws.batch.SchedulingPolicyArgs;
 * import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SchedulingPolicy("example", SchedulingPolicyArgs.builder()
 *             .name("example")
 *             .fairSharePolicy(SchedulingPolicyFairSharePolicyArgs.builder()
 *                 .computeReservation(1)
 *                 .shareDecaySeconds(3600)
 *                 .shareDistributions(SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                     .shareIdentifier("A1*")
 *                     .weightFactor(0.1)
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleJobQueue = new JobQueue("exampleJobQueue", JobQueueArgs.builder()
 *             .name("tf-test-batch-job-queue")
 *             .schedulingPolicyArn(example.arn())
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironmentOrders(
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(1)
 *                     .computeEnvironment(testEnvironment1.arn())
 *                     .build(),
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(2)
 *                     .computeEnvironment(testEnvironment2.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:batch:SchedulingPolicy
 *     properties:
 *       name: example
 *       fairSharePolicy:
 *         computeReservation: 1
 *         shareDecaySeconds: 3600
 *         shareDistributions:
 *           - shareIdentifier: A1*
 *             weightFactor: 0.1
 *   exampleJobQueue:
 *     type: aws:batch:JobQueue
 *     name: example
 *     properties:
 *       name: tf-test-batch-job-queue
 *       schedulingPolicyArn: ${example.arn}
 *       state: ENABLED
 *       priority: 1
 *       computeEnvironmentOrders:
 *         - order: 1
 *           computeEnvironment: ${testEnvironment1.arn}
 *         - order: 2
 *           computeEnvironment: ${testEnvironment2.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Batch Job Queue using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:batch/jobQueue:JobQueue test_queue arn:aws:batch:us-east-1:123456789012:job-queue/sample
 * ```
 */
public class JobQueue internal constructor(
    override val javaResource: com.pulumi.aws.batch.JobQueue,
) : KotlinCustomResource(javaResource, JobQueueMapper) {
    /**
     * The Amazon Resource Name of the job queue.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    public val computeEnvironmentOrders: Output<List<JobQueueComputeEnvironmentOrder>>?
        get() = javaResource.computeEnvironmentOrders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        jobQueueComputeEnvironmentOrderToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * (Optional) This parameter is deprecated, please use `compute_environment_order` instead. List of compute environment ARNs mapped to a job queue. The position of the compute environments in the list will dictate the order. When importing a AWS Batch Job Queue, the parameter `compute_environments` will always be used over `compute_environment_order`. Please adjust your HCL accordingly.
     */
    @Deprecated(
        message = """
  This parameter will be replaced by `compute_environment_order`.
  """,
    )
    public val computeEnvironments: Output<List<String>>?
        get() = javaResource.computeEnvironments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies the name of the job queue.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of the job queue. Job queues with a higher priority
     * are evaluated first when associated with the same compute environment.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
     */
    public val schedulingPolicyArn: Output<String>?
        get() = javaResource.schedulingPolicyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<JobQueueTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    jobQueueTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object JobQueueMapper : ResourceMapper<JobQueue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.batch.JobQueue::class == javaResource::class

    override fun map(javaResource: Resource): JobQueue = JobQueue(
        javaResource as
            com.pulumi.aws.batch.JobQueue,
    )
}

/**
 * @see [JobQueue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobQueue].
 */
public suspend fun jobQueue(name: String, block: suspend JobQueueResourceBuilder.() -> Unit): JobQueue {
    val builder = JobQueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobQueue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobQueue(name: String): JobQueue {
    val builder = JobQueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
