@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.JobQueueArgs.builder
import com.pulumi.aws.batch.kotlin.inputs.JobQueueComputeEnvironmentOrderArgs
import com.pulumi.aws.batch.kotlin.inputs.JobQueueComputeEnvironmentOrderArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.JobQueueTimeoutsArgs
import com.pulumi.aws.batch.kotlin.inputs.JobQueueTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Batch Job Queue resource.
 * ## Example Usage
 * ### Basic Job Queue
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testQueue = new aws.batch.JobQueue("test_queue", {
 *     name: "tf-test-batch-job-queue",
 *     state: "ENABLED",
 *     priority: 1,
 *     computeEnvironmentOrders: [
 *         {
 *             order: 1,
 *             computeEnvironment: testEnvironment1.arn,
 *         },
 *         {
 *             order: 2,
 *             computeEnvironment: testEnvironment2.arn,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_queue = aws.batch.JobQueue("test_queue",
 *     name="tf-test-batch-job-queue",
 *     state="ENABLED",
 *     priority=1,
 *     compute_environment_orders=[
 *         {
 *             "order": 1,
 *             "compute_environment": test_environment1["arn"],
 *         },
 *         {
 *             "order": 2,
 *             "compute_environment": test_environment2["arn"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testQueue = new Aws.Batch.JobQueue("test_queue", new()
 *     {
 *         Name = "tf-test-batch-job-queue",
 *         State = "ENABLED",
 *         Priority = 1,
 *         ComputeEnvironmentOrders = new[]
 *         {
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 1,
 *                 ComputeEnvironment = testEnvironment1.Arn,
 *             },
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 2,
 *                 ComputeEnvironment = testEnvironment2.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewJobQueue(ctx, "test_queue", &batch.JobQueueArgs{
 * 			Name:     pulumi.String("tf-test-batch-job-queue"),
 * 			State:    pulumi.String("ENABLED"),
 * 			Priority: pulumi.Int(1),
 * 			ComputeEnvironmentOrders: batch.JobQueueComputeEnvironmentOrderArray{
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(1),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment1.Arn),
 * 				},
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(2),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment2.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testQueue = new JobQueue("testQueue", JobQueueArgs.builder()
 *             .name("tf-test-batch-job-queue")
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironmentOrders(
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(1)
 *                     .computeEnvironment(testEnvironment1.arn())
 *                     .build(),
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(2)
 *                     .computeEnvironment(testEnvironment2.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testQueue:
 *     type: aws:batch:JobQueue
 *     name: test_queue
 *     properties:
 *       name: tf-test-batch-job-queue
 *       state: ENABLED
 *       priority: 1
 *       computeEnvironmentOrders:
 *         - order: 1
 *           computeEnvironment: ${testEnvironment1.arn}
 *         - order: 2
 *           computeEnvironment: ${testEnvironment2.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Job Queue with a fair share scheduling policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.batch.SchedulingPolicy("example", {
 *     name: "example",
 *     fairSharePolicy: {
 *         computeReservation: 1,
 *         shareDecaySeconds: 3600,
 *         shareDistributions: [{
 *             shareIdentifier: "A1*",
 *             weightFactor: 0.1,
 *         }],
 *     },
 * });
 * const exampleJobQueue = new aws.batch.JobQueue("example", {
 *     name: "tf-test-batch-job-queue",
 *     schedulingPolicyArn: example.arn,
 *     state: "ENABLED",
 *     priority: 1,
 *     computeEnvironmentOrders: [
 *         {
 *             order: 1,
 *             computeEnvironment: testEnvironment1.arn,
 *         },
 *         {
 *             order: 2,
 *             computeEnvironment: testEnvironment2.arn,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.batch.SchedulingPolicy("example",
 *     name="example",
 *     fair_share_policy={
 *         "compute_reservation": 1,
 *         "share_decay_seconds": 3600,
 *         "share_distributions": [{
 *             "share_identifier": "A1*",
 *             "weight_factor": 0.1,
 *         }],
 *     })
 * example_job_queue = aws.batch.JobQueue("example",
 *     name="tf-test-batch-job-queue",
 *     scheduling_policy_arn=example.arn,
 *     state="ENABLED",
 *     priority=1,
 *     compute_environment_orders=[
 *         {
 *             "order": 1,
 *             "compute_environment": test_environment1["arn"],
 *         },
 *         {
 *             "order": 2,
 *             "compute_environment": test_environment2["arn"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Batch.SchedulingPolicy("example", new()
 *     {
 *         Name = "example",
 *         FairSharePolicy = new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyArgs
 *         {
 *             ComputeReservation = 1,
 *             ShareDecaySeconds = 3600,
 *             ShareDistributions = new[]
 *             {
 *                 new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs
 *                 {
 *                     ShareIdentifier = "A1*",
 *                     WeightFactor = 0.1,
 *                 },
 *             },
 *         },
 *     });
 *     var exampleJobQueue = new Aws.Batch.JobQueue("example", new()
 *     {
 *         Name = "tf-test-batch-job-queue",
 *         SchedulingPolicyArn = example.Arn,
 *         State = "ENABLED",
 *         Priority = 1,
 *         ComputeEnvironmentOrders = new[]
 *         {
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 1,
 *                 ComputeEnvironment = testEnvironment1.Arn,
 *             },
 *             new Aws.Batch.Inputs.JobQueueComputeEnvironmentOrderArgs
 *             {
 *                 Order = 2,
 *                 ComputeEnvironment = testEnvironment2.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := batch.NewSchedulingPolicy(ctx, "example", &batch.SchedulingPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FairSharePolicy: &batch.SchedulingPolicyFairSharePolicyArgs{
 * 				ComputeReservation: pulumi.Int(1),
 * 				ShareDecaySeconds:  pulumi.Int(3600),
 * 				ShareDistributions: batch.SchedulingPolicyFairSharePolicyShareDistributionArray{
 * 					&batch.SchedulingPolicyFairSharePolicyShareDistributionArgs{
 * 						ShareIdentifier: pulumi.String("A1*"),
 * 						WeightFactor:    pulumi.Float64(0.1),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = batch.NewJobQueue(ctx, "example", &batch.JobQueueArgs{
 * 			Name:                pulumi.String("tf-test-batch-job-queue"),
 * 			SchedulingPolicyArn: example.Arn,
 * 			State:               pulumi.String("ENABLED"),
 * 			Priority:            pulumi.Int(1),
 * 			ComputeEnvironmentOrders: batch.JobQueueComputeEnvironmentOrderArray{
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(1),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment1.Arn),
 * 				},
 * 				&batch.JobQueueComputeEnvironmentOrderArgs{
 * 					Order:              pulumi.Int(2),
 * 					ComputeEnvironment: pulumi.Any(testEnvironment2.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.SchedulingPolicy;
 * import com.pulumi.aws.batch.SchedulingPolicyArgs;
 * import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SchedulingPolicy("example", SchedulingPolicyArgs.builder()
 *             .name("example")
 *             .fairSharePolicy(SchedulingPolicyFairSharePolicyArgs.builder()
 *                 .computeReservation(1)
 *                 .shareDecaySeconds(3600)
 *                 .shareDistributions(SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                     .shareIdentifier("A1*")
 *                     .weightFactor(0.1)
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleJobQueue = new JobQueue("exampleJobQueue", JobQueueArgs.builder()
 *             .name("tf-test-batch-job-queue")
 *             .schedulingPolicyArn(example.arn())
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironmentOrders(
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(1)
 *                     .computeEnvironment(testEnvironment1.arn())
 *                     .build(),
 *                 JobQueueComputeEnvironmentOrderArgs.builder()
 *                     .order(2)
 *                     .computeEnvironment(testEnvironment2.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:batch:SchedulingPolicy
 *     properties:
 *       name: example
 *       fairSharePolicy:
 *         computeReservation: 1
 *         shareDecaySeconds: 3600
 *         shareDistributions:
 *           - shareIdentifier: A1*
 *             weightFactor: 0.1
 *   exampleJobQueue:
 *     type: aws:batch:JobQueue
 *     name: example
 *     properties:
 *       name: tf-test-batch-job-queue
 *       schedulingPolicyArn: ${example.arn}
 *       state: ENABLED
 *       priority: 1
 *       computeEnvironmentOrders:
 *         - order: 1
 *           computeEnvironment: ${testEnvironment1.arn}
 *         - order: 2
 *           computeEnvironment: ${testEnvironment2.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Batch Job Queue using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:batch/jobQueue:JobQueue test_queue arn:aws:batch:us-east-1:123456789012:job-queue/sample
 * ```
 * @property computeEnvironmentOrders The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
 * @property computeEnvironments (Optional) This parameter is deprecated, please use `compute_environment_order` instead. List of compute environment ARNs mapped to a job queue. The position of the compute environments in the list will dictate the order. When importing a AWS Batch Job Queue, the parameter `compute_environments` will always be used over `compute_environment_order`. Please adjust your HCL accordingly.
 * @property name Specifies the name of the job queue.
 * @property priority The priority of the job queue. Job queues with a higher priority
 * are evaluated first when associated with the same compute environment.
 * @property schedulingPolicyArn The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
 * @property state The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class JobQueueArgs(
    public val computeEnvironmentOrders: Output<List<JobQueueComputeEnvironmentOrderArgs>>? = null,
    @Deprecated(
        message = """
  This parameter will be replaced by `compute_environment_order`.
  """,
    )
    public val computeEnvironments: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val schedulingPolicyArn: Output<String>? = null,
    public val state: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<JobQueueTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.JobQueueArgs> {
    override fun toJava(): com.pulumi.aws.batch.JobQueueArgs =
        com.pulumi.aws.batch.JobQueueArgs.builder()
            .computeEnvironmentOrders(
                computeEnvironmentOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .computeEnvironments(computeEnvironments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .schedulingPolicyArn(schedulingPolicyArn?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobQueueArgs].
 */
@PulumiTagMarker
public class JobQueueArgsBuilder internal constructor() {
    private var computeEnvironmentOrders: Output<List<JobQueueComputeEnvironmentOrderArgs>>? = null

    private var computeEnvironments: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var schedulingPolicyArn: Output<String>? = null

    private var state: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<JobQueueTimeoutsArgs>? = null

    /**
     * @param value The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    @JvmName("pjkxyrtjpnawuhyg")
    public suspend fun computeEnvironmentOrders(`value`: Output<List<JobQueueComputeEnvironmentOrderArgs>>) {
        this.computeEnvironmentOrders = value
    }

    @JvmName("tggblxyqledensth")
    public suspend fun computeEnvironmentOrders(vararg values: Output<JobQueueComputeEnvironmentOrderArgs>) {
        this.computeEnvironmentOrders = Output.all(values.asList())
    }

    /**
     * @param values The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    @JvmName("tlfxabkerijvbdjr")
    public suspend fun computeEnvironmentOrders(values: List<Output<JobQueueComputeEnvironmentOrderArgs>>) {
        this.computeEnvironmentOrders = Output.all(values)
    }

    /**
     * @param value (Optional) This parameter is deprecated, please use `compute_environment_order` instead. List of compute environment ARNs mapped to a job queue. The position of the compute environments in the list will dictate the order. When importing a AWS Batch Job Queue, the parameter `compute_environments` will always be used over `compute_environment_order`. Please adjust your HCL accordingly.
     */
    @Deprecated(
        message = """
  This parameter will be replaced by `compute_environment_order`.
  """,
    )
    @JvmName("ygoowtadwbabxxaw")
    public suspend fun computeEnvironments(`value`: Output<List<String>>) {
        this.computeEnvironments = value
    }

    @JvmName("wirdmnnyfwsmrevg")
    public suspend fun computeEnvironments(vararg values: Output<String>) {
        this.computeEnvironments = Output.all(values.asList())
    }

    /**
     * @param values (Optional) This parameter is deprecated, please use `compute_environment_order` instead. List of compute environment ARNs mapped to a job queue. The position of the compute environments in the list will dictate the order. When importing a AWS Batch Job Queue, the parameter `compute_environments` will always be used over `compute_environment_order`. Please adjust your HCL accordingly.
     */
    @Deprecated(
        message = """
  This parameter will be replaced by `compute_environment_order`.
  """,
    )
    @JvmName("mmorhmukliqtcgpj")
    public suspend fun computeEnvironments(values: List<Output<String>>) {
        this.computeEnvironments = Output.all(values)
    }

    /**
     * @param value Specifies the name of the job queue.
     */
    @JvmName("huhhwiqurmdfwdso")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the job queue. Job queues with a higher priority
     * are evaluated first when associated with the same compute environment.
     */
    @JvmName("owjrmkfbnxbhtqpt")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
     */
    @JvmName("lnjainsgqjvgjmad")
    public suspend fun schedulingPolicyArn(`value`: Output<String>) {
        this.schedulingPolicyArn = value
    }

    /**
     * @param value The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
     */
    @JvmName("tkgndxaqggofbvlg")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("brhncbtdwehdcjyg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ghlxuauokcnmhrgm")
    public suspend fun timeouts(`value`: Output<JobQueueTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    @JvmName("oxmrprceyuaytkas")
    public suspend fun computeEnvironmentOrders(`value`: List<JobQueueComputeEnvironmentOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeEnvironmentOrders = mapped
    }

    /**
     * @param argument The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    @JvmName("drheendaquvmqjcy")
    public suspend fun computeEnvironmentOrders(argument: List<suspend JobQueueComputeEnvironmentOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobQueueComputeEnvironmentOrderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computeEnvironmentOrders = mapped
    }

    /**
     * @param argument The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    @JvmName("kajretwlxewpcdmk")
    public suspend fun computeEnvironmentOrders(vararg argument: suspend JobQueueComputeEnvironmentOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobQueueComputeEnvironmentOrderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computeEnvironmentOrders = mapped
    }

    /**
     * @param argument The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    @JvmName("khdxmeiichfhhbuc")
    public suspend fun computeEnvironmentOrders(argument: suspend JobQueueComputeEnvironmentOrderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JobQueueComputeEnvironmentOrderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.computeEnvironmentOrders = mapped
    }

    /**
     * @param values The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue.
     */
    @JvmName("ktmwypfwjncfnfqo")
    public suspend fun computeEnvironmentOrders(vararg values: JobQueueComputeEnvironmentOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeEnvironmentOrders = mapped
    }

    /**
     * @param value (Optional) This parameter is deprecated, please use `compute_environment_order` instead. List of compute environment ARNs mapped to a job queue. The position of the compute environments in the list will dictate the order. When importing a AWS Batch Job Queue, the parameter `compute_environments` will always be used over `compute_environment_order`. Please adjust your HCL accordingly.
     */
    @Deprecated(
        message = """
  This parameter will be replaced by `compute_environment_order`.
  """,
    )
    @JvmName("hpwmbdehrrplgoqo")
    public suspend fun computeEnvironments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeEnvironments = mapped
    }

    /**
     * @param values (Optional) This parameter is deprecated, please use `compute_environment_order` instead. List of compute environment ARNs mapped to a job queue. The position of the compute environments in the list will dictate the order. When importing a AWS Batch Job Queue, the parameter `compute_environments` will always be used over `compute_environment_order`. Please adjust your HCL accordingly.
     */
    @Deprecated(
        message = """
  This parameter will be replaced by `compute_environment_order`.
  """,
    )
    @JvmName("kcorndoqsuuiitkc")
    public suspend fun computeEnvironments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeEnvironments = mapped
    }

    /**
     * @param value Specifies the name of the job queue.
     */
    @JvmName("tcjnjcrwbgauyqde")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the job queue. Job queues with a higher priority
     * are evaluated first when associated with the same compute environment.
     */
    @JvmName("gicxxvumkmqvgjgt")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
     */
    @JvmName("vviljgdtdepxbuwj")
    public suspend fun schedulingPolicyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulingPolicyArn = mapped
    }

    /**
     * @param value The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
     */
    @JvmName("udoybjjictuctfsl")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iorvjjcscdasneye")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nmkwcuwdshtiawuj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("fckdxhhtjtypavmp")
    public suspend fun timeouts(`value`: JobQueueTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wxygvldqrqmhxxtr")
    public suspend fun timeouts(argument: suspend JobQueueTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = JobQueueTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): JobQueueArgs = JobQueueArgs(
        computeEnvironmentOrders = computeEnvironmentOrders,
        computeEnvironments = computeEnvironments,
        name = name,
        priority = priority,
        schedulingPolicyArn = schedulingPolicyArn,
        state = state,
        tags = tags,
        timeouts = timeouts,
    )
}
