@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.kotlin.outputs.SchedulingPolicyFairSharePolicy
import com.pulumi.aws.batch.kotlin.outputs.SchedulingPolicyFairSharePolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SchedulingPolicy].
 */
@PulumiTagMarker
public class SchedulingPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SchedulingPolicyArgs = SchedulingPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SchedulingPolicyArgsBuilder.() -> Unit) {
        val builder = SchedulingPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SchedulingPolicy {
        val builtJavaResource = com.pulumi.aws.batch.SchedulingPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SchedulingPolicy(builtJavaResource)
    }
}

/**
 * Provides a Batch Scheduling Policy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.batch.SchedulingPolicy("example", {
 *     name: "example",
 *     fairSharePolicy: {
 *         computeReservation: 1,
 *         shareDecaySeconds: 3600,
 *         shareDistributions: [
 *             {
 *                 shareIdentifier: "A1*",
 *                 weightFactor: 0.1,
 *             },
 *             {
 *                 shareIdentifier: "A2",
 *                 weightFactor: 0.2,
 *             },
 *         ],
 *     },
 *     tags: {
 *         Name: "Example Batch Scheduling Policy",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.batch.SchedulingPolicy("example",
 *     name="example",
 *     fair_share_policy={
 *         "compute_reservation": 1,
 *         "share_decay_seconds": 3600,
 *         "share_distributions": [
 *             {
 *                 "share_identifier": "A1*",
 *                 "weight_factor": 0.1,
 *             },
 *             {
 *                 "share_identifier": "A2",
 *                 "weight_factor": 0.2,
 *             },
 *         ],
 *     },
 *     tags={
 *         "Name": "Example Batch Scheduling Policy",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Batch.SchedulingPolicy("example", new()
 *     {
 *         Name = "example",
 *         FairSharePolicy = new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyArgs
 *         {
 *             ComputeReservation = 1,
 *             ShareDecaySeconds = 3600,
 *             ShareDistributions = new[]
 *             {
 *                 new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs
 *                 {
 *                     ShareIdentifier = "A1*",
 *                     WeightFactor = 0.1,
 *                 },
 *                 new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs
 *                 {
 *                     ShareIdentifier = "A2",
 *                     WeightFactor = 0.2,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Batch Scheduling Policy" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewSchedulingPolicy(ctx, "example", &batch.SchedulingPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FairSharePolicy: &batch.SchedulingPolicyFairSharePolicyArgs{
 * 				ComputeReservation: pulumi.Int(1),
 * 				ShareDecaySeconds:  pulumi.Int(3600),
 * 				ShareDistributions: batch.SchedulingPolicyFairSharePolicyShareDistributionArray{
 * 					&batch.SchedulingPolicyFairSharePolicyShareDistributionArgs{
 * 						ShareIdentifier: pulumi.String("A1*"),
 * 						WeightFactor:    pulumi.Float64(0.1),
 * 					},
 * 					&batch.SchedulingPolicyFairSharePolicyShareDistributionArgs{
 * 						ShareIdentifier: pulumi.String("A2"),
 * 						WeightFactor:    pulumi.Float64(0.2),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Batch Scheduling Policy"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.SchedulingPolicy;
 * import com.pulumi.aws.batch.SchedulingPolicyArgs;
 * import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SchedulingPolicy("example", SchedulingPolicyArgs.builder()
 *             .name("example")
 *             .fairSharePolicy(SchedulingPolicyFairSharePolicyArgs.builder()
 *                 .computeReservation(1)
 *                 .shareDecaySeconds(3600)
 *                 .shareDistributions(
 *                     SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                         .shareIdentifier("A1*")
 *                         .weightFactor(0.1)
 *                         .build(),
 *                     SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                         .shareIdentifier("A2")
 *                         .weightFactor(0.2)
 *                         .build())
 *                 .build())
 *             .tags(Map.of("Name", "Example Batch Scheduling Policy"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:batch:SchedulingPolicy
 *     properties:
 *       name: example
 *       fairSharePolicy:
 *         computeReservation: 1
 *         shareDecaySeconds: 3600
 *         shareDistributions:
 *           - shareIdentifier: A1*
 *             weightFactor: 0.1
 *           - shareIdentifier: A2
 *             weightFactor: 0.2
 *       tags:
 *         Name: Example Batch Scheduling Policy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Batch Scheduling Policy using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:batch/schedulingPolicy:SchedulingPolicy test_policy arn:aws:batch:us-east-1:123456789012:scheduling-policy/sample
 * ```
 */
public class SchedulingPolicy internal constructor(
    override val javaResource: com.pulumi.aws.batch.SchedulingPolicy,
) : KotlinCustomResource(javaResource, SchedulingPolicyMapper) {
    /**
     * The Amazon Resource Name of the scheduling policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val fairSharePolicy: Output<SchedulingPolicyFairSharePolicy>?
        get() = javaResource.fairSharePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the name of the scheduling policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SchedulingPolicyMapper : ResourceMapper<SchedulingPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.batch.SchedulingPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SchedulingPolicy = SchedulingPolicy(
        javaResource as
            com.pulumi.aws.batch.SchedulingPolicy,
    )
}

/**
 * @see [SchedulingPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SchedulingPolicy].
 */
public suspend fun schedulingPolicy(
    name: String,
    block: suspend SchedulingPolicyResourceBuilder.() -> Unit,
): SchedulingPolicy {
    val builder = SchedulingPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SchedulingPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedulingPolicy(name: String): SchedulingPolicy {
    val builder = SchedulingPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
