@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.SchedulingPolicyArgs.builder
import com.pulumi.aws.batch.kotlin.inputs.SchedulingPolicyFairSharePolicyArgs
import com.pulumi.aws.batch.kotlin.inputs.SchedulingPolicyFairSharePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Batch Scheduling Policy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.batch.SchedulingPolicy("example", {
 *     name: "example",
 *     fairSharePolicy: {
 *         computeReservation: 1,
 *         shareDecaySeconds: 3600,
 *         shareDistributions: [
 *             {
 *                 shareIdentifier: "A1*",
 *                 weightFactor: 0.1,
 *             },
 *             {
 *                 shareIdentifier: "A2",
 *                 weightFactor: 0.2,
 *             },
 *         ],
 *     },
 *     tags: {
 *         Name: "Example Batch Scheduling Policy",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.batch.SchedulingPolicy("example",
 *     name="example",
 *     fair_share_policy={
 *         "compute_reservation": 1,
 *         "share_decay_seconds": 3600,
 *         "share_distributions": [
 *             {
 *                 "share_identifier": "A1*",
 *                 "weight_factor": 0.1,
 *             },
 *             {
 *                 "share_identifier": "A2",
 *                 "weight_factor": 0.2,
 *             },
 *         ],
 *     },
 *     tags={
 *         "Name": "Example Batch Scheduling Policy",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Batch.SchedulingPolicy("example", new()
 *     {
 *         Name = "example",
 *         FairSharePolicy = new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyArgs
 *         {
 *             ComputeReservation = 1,
 *             ShareDecaySeconds = 3600,
 *             ShareDistributions = new[]
 *             {
 *                 new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs
 *                 {
 *                     ShareIdentifier = "A1*",
 *                     WeightFactor = 0.1,
 *                 },
 *                 new Aws.Batch.Inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs
 *                 {
 *                     ShareIdentifier = "A2",
 *                     WeightFactor = 0.2,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Batch Scheduling Policy" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/batch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewSchedulingPolicy(ctx, "example", &batch.SchedulingPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FairSharePolicy: &batch.SchedulingPolicyFairSharePolicyArgs{
 * 				ComputeReservation: pulumi.Int(1),
 * 				ShareDecaySeconds:  pulumi.Int(3600),
 * 				ShareDistributions: batch.SchedulingPolicyFairSharePolicyShareDistributionArray{
 * 					&batch.SchedulingPolicyFairSharePolicyShareDistributionArgs{
 * 						ShareIdentifier: pulumi.String("A1*"),
 * 						WeightFactor:    pulumi.Float64(0.1),
 * 					},
 * 					&batch.SchedulingPolicyFairSharePolicyShareDistributionArgs{
 * 						ShareIdentifier: pulumi.String("A2"),
 * 						WeightFactor:    pulumi.Float64(0.2),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Batch Scheduling Policy"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.SchedulingPolicy;
 * import com.pulumi.aws.batch.SchedulingPolicyArgs;
 * import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SchedulingPolicy("example", SchedulingPolicyArgs.builder()
 *             .name("example")
 *             .fairSharePolicy(SchedulingPolicyFairSharePolicyArgs.builder()
 *                 .computeReservation(1)
 *                 .shareDecaySeconds(3600)
 *                 .shareDistributions(
 *                     SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                         .shareIdentifier("A1*")
 *                         .weightFactor(0.1)
 *                         .build(),
 *                     SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                         .shareIdentifier("A2")
 *                         .weightFactor(0.2)
 *                         .build())
 *                 .build())
 *             .tags(Map.of("Name", "Example Batch Scheduling Policy"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:batch:SchedulingPolicy
 *     properties:
 *       name: example
 *       fairSharePolicy:
 *         computeReservation: 1
 *         shareDecaySeconds: 3600
 *         shareDistributions:
 *           - shareIdentifier: A1*
 *             weightFactor: 0.1
 *           - shareIdentifier: A2
 *             weightFactor: 0.2
 *       tags:
 *         Name: Example Batch Scheduling Policy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Batch Scheduling Policy using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:batch/schedulingPolicy:SchedulingPolicy test_policy arn:aws:batch:us-east-1:123456789012:scheduling-policy/sample
 * ```
 * @property fairSharePolicy
 * @property name Specifies the name of the scheduling policy.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SchedulingPolicyArgs(
    public val fairSharePolicy: Output<SchedulingPolicyFairSharePolicyArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.SchedulingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.batch.SchedulingPolicyArgs =
        com.pulumi.aws.batch.SchedulingPolicyArgs.builder()
            .fairSharePolicy(fairSharePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SchedulingPolicyArgs].
 */
@PulumiTagMarker
public class SchedulingPolicyArgsBuilder internal constructor() {
    private var fairSharePolicy: Output<SchedulingPolicyFairSharePolicyArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("dfqfnpgkcogygtey")
    public suspend fun fairSharePolicy(`value`: Output<SchedulingPolicyFairSharePolicyArgs>) {
        this.fairSharePolicy = value
    }

    /**
     * @param value Specifies the name of the scheduling policy.
     */
    @JvmName("tyopqoipwodrwqtw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pavhrdhjgedwhjbr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("eyoonsibkkbmixhg")
    public suspend fun fairSharePolicy(`value`: SchedulingPolicyFairSharePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fairSharePolicy = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mrcwdmlqhqxuxihe")
    public suspend fun fairSharePolicy(argument: suspend SchedulingPolicyFairSharePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = SchedulingPolicyFairSharePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fairSharePolicy = mapped
    }

    /**
     * @param value Specifies the name of the scheduling policy.
     */
    @JvmName("sxlqeglnjnuqndgb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ckxjexrmhutkcufg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtovtlbbtsbcjiga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SchedulingPolicyArgs = SchedulingPolicyArgs(
        fairSharePolicy = fairSharePolicy,
        name = name,
        tags = tags,
    )
}
