@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesEc2ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property imageIdOverride The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
 * @property imageType The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
 */
public data class ComputeEnvironmentComputeResourcesEc2ConfigurationArgs(
    public val imageIdOverride: Output<String>? = null,
    public val imageType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesEc2ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesEc2ConfigurationArgs =
        com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesEc2ConfigurationArgs.builder()
            .imageIdOverride(imageIdOverride?.applyValue({ args0 -> args0 }))
            .imageType(imageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeEnvironmentComputeResourcesEc2ConfigurationArgs].
 */
@PulumiTagMarker
public class ComputeEnvironmentComputeResourcesEc2ConfigurationArgsBuilder internal constructor() {
    private var imageIdOverride: Output<String>? = null

    private var imageType: Output<String>? = null

    /**
     * @param value The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
     */
    @JvmName("mkmevppgtcwqtsak")
    public suspend fun imageIdOverride(`value`: Output<String>) {
        this.imageIdOverride = value
    }

    /**
     * @param value The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
     */
    @JvmName("gvxfyxprffkqxluv")
    public suspend fun imageType(`value`: Output<String>) {
        this.imageType = value
    }

    /**
     * @param value The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
     */
    @JvmName("whdqbiiktnyvjagt")
    public suspend fun imageIdOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageIdOverride = mapped
    }

    /**
     * @param value The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
     */
    @JvmName("yatwemyrmxnobymw")
    public suspend fun imageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageType = mapped
    }

    internal fun build(): ComputeEnvironmentComputeResourcesEc2ConfigurationArgs =
        ComputeEnvironmentComputeResourcesEc2ConfigurationArgs(
            imageIdOverride = imageIdOverride,
            imageType = imageType,
        )
}
