@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesLaunchTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property launchTemplateId ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
 * @property launchTemplateName Name of the launch template.
 * @property version The version number of the launch template. Default: The default version of the launch template.
 */
public data class ComputeEnvironmentComputeResourcesLaunchTemplateArgs(
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesLaunchTemplateArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesLaunchTemplateArgs =
        com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesLaunchTemplateArgs.builder()
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeEnvironmentComputeResourcesLaunchTemplateArgs].
 */
@PulumiTagMarker
public class ComputeEnvironmentComputeResourcesLaunchTemplateArgsBuilder internal constructor() {
    private var launchTemplateId: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
     */
    @JvmName("flibxbvrmtipkrmr")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value Name of the launch template.
     */
    @JvmName("hgdhbqarpncdtwog")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value The version number of the launch template. Default: The default version of the launch template.
     */
    @JvmName("mpyrqnrwceqagppe")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
     */
    @JvmName("bllpwypgufrvmntd")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value Name of the launch template.
     */
    @JvmName("idapghucnyleymoo")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value The version number of the launch template. Default: The default version of the launch template.
     */
    @JvmName("ytxfatgvcbkvtorr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ComputeEnvironmentComputeResourcesLaunchTemplateArgs =
        ComputeEnvironmentComputeResourcesLaunchTemplateArgs(
            launchTemplateId = launchTemplateId,
            launchTemplateName = launchTemplateName,
            version = version,
        )
}
