@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.ComputeEnvironmentUpdatePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobExecutionTimeoutMinutes Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
 * @property terminateJobsOnUpdate Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
 */
public data class ComputeEnvironmentUpdatePolicyArgs(
    public val jobExecutionTimeoutMinutes: Output<Int>,
    public val terminateJobsOnUpdate: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.ComputeEnvironmentUpdatePolicyArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.ComputeEnvironmentUpdatePolicyArgs =
        com.pulumi.aws.batch.inputs.ComputeEnvironmentUpdatePolicyArgs.builder()
            .jobExecutionTimeoutMinutes(jobExecutionTimeoutMinutes.applyValue({ args0 -> args0 }))
            .terminateJobsOnUpdate(terminateJobsOnUpdate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeEnvironmentUpdatePolicyArgs].
 */
@PulumiTagMarker
public class ComputeEnvironmentUpdatePolicyArgsBuilder internal constructor() {
    private var jobExecutionTimeoutMinutes: Output<Int>? = null

    private var terminateJobsOnUpdate: Output<Boolean>? = null

    /**
     * @param value Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
     */
    @JvmName("gxgecfbkopwclvcg")
    public suspend fun jobExecutionTimeoutMinutes(`value`: Output<Int>) {
        this.jobExecutionTimeoutMinutes = value
    }

    /**
     * @param value Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
     */
    @JvmName("fquejhbolxodylti")
    public suspend fun terminateJobsOnUpdate(`value`: Output<Boolean>) {
        this.terminateJobsOnUpdate = value
    }

    /**
     * @param value Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
     */
    @JvmName("uprrhbjqfstutcxb")
    public suspend fun jobExecutionTimeoutMinutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobExecutionTimeoutMinutes = mapped
    }

    /**
     * @param value Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
     */
    @JvmName("htytewopnglqhwpp")
    public suspend fun terminateJobsOnUpdate(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.terminateJobsOnUpdate = mapped
    }

    internal fun build(): ComputeEnvironmentUpdatePolicyArgs = ComputeEnvironmentUpdatePolicyArgs(
        jobExecutionTimeoutMinutes = jobExecutionTimeoutMinutes ?: throw
            PulumiNullFieldException("jobExecutionTimeoutMinutes"),
        terminateJobsOnUpdate = terminateJobsOnUpdate ?: throw
            PulumiNullFieldException("terminateJobsOnUpdate"),
    )
}
