@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.GetComputeEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getComputeEnvironment.
 * @property computeEnvironmentName Name of the Batch Compute Environment
 * @property tags Key-value map of resource tags
 */
public data class GetComputeEnvironmentPlainArgs(
    public val computeEnvironmentName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.GetComputeEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.GetComputeEnvironmentPlainArgs =
        com.pulumi.aws.batch.inputs.GetComputeEnvironmentPlainArgs.builder()
            .computeEnvironmentName(computeEnvironmentName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetComputeEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetComputeEnvironmentPlainArgsBuilder internal constructor() {
    private var computeEnvironmentName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the Batch Compute Environment
     */
    @JvmName("najtxodjavbhvebv")
    public suspend fun computeEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.computeEnvironmentName = mapped
    }

    /**
     * @param value Key-value map of resource tags
     */
    @JvmName("jmfkmthwxmsaasso")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags
     */
    @JvmName("ghyltlwmlesrxkvj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetComputeEnvironmentPlainArgs = GetComputeEnvironmentPlainArgs(
        computeEnvironmentName = computeEnvironmentName ?: throw
            PulumiNullFieldException("computeEnvironmentName"),
        tags = tags,
    )
}
