@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.GetJobDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getJobDefinition.
 * @property arn ARN of the Job Definition. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
 * @property name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
 * @property revision The revision of the job definition.
 * @property status The status of the job definition.
 */
public data class GetJobDefinitionPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val revision: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.GetJobDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.GetJobDefinitionPlainArgs =
        com.pulumi.aws.batch.inputs.GetJobDefinitionPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .revision(revision?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetJobDefinitionPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var revision: Int? = null

    private var status: String? = null

    /**
     * @param value ARN of the Job Definition. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
     */
    @JvmName("koohmuvgajeqjejh")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    @JvmName("gwuxkajolqrjypnj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The revision of the job definition.
     */
    @JvmName("kpbhbfbmyvfrxamh")
    public suspend fun revision(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.revision = mapped
    }

    /**
     * @param value The status of the job definition.
     */
    @JvmName("wwpdnxnkvfmusmxt")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetJobDefinitionPlainArgs = GetJobDefinitionPlainArgs(
        arn = arn,
        name = name,
        revision = revision,
        status = status,
    )
}
