@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.GetSchedulingPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSchedulingPolicy.
 * @property arn ARN of the scheduling policy.
 * @property tags Key-value map of resource tags
 */
public data class GetSchedulingPolicyPlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.GetSchedulingPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.GetSchedulingPolicyPlainArgs =
        com.pulumi.aws.batch.inputs.GetSchedulingPolicyPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSchedulingPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetSchedulingPolicyPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the scheduling policy.
     */
    @JvmName("exwyylvibyncwslj")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Key-value map of resource tags
     */
    @JvmName("hdpducegjgwdielh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags
     */
    @JvmName("glkpowaujiplaypf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSchedulingPolicyPlainArgs = GetSchedulingPolicyPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        tags = tags,
    )
}
