@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property podProperties Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
 */
public data class JobDefinitionEksPropertiesArgs(
    public val podProperties: Output<JobDefinitionEksPropertiesPodPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesArgs.builder()
            .podProperties(podProperties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesArgsBuilder internal constructor() {
    private var podProperties: Output<JobDefinitionEksPropertiesPodPropertiesArgs>? = null

    /**
     * @param value Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
     */
    @JvmName("ubhabgabufxbnwui")
    public suspend fun podProperties(`value`: Output<JobDefinitionEksPropertiesPodPropertiesArgs>) {
        this.podProperties = value
    }

    /**
     * @param value Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
     */
    @JvmName("ckeaetjwvrecntea")
    public suspend fun podProperties(`value`: JobDefinitionEksPropertiesPodPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podProperties = mapped
    }

    /**
     * @param argument Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
     */
    @JvmName("chjjknwbboitmriq")
    public suspend fun podProperties(argument: suspend JobDefinitionEksPropertiesPodPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = JobDefinitionEksPropertiesPodPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.podProperties = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesArgs = JobDefinitionEksPropertiesArgs(
        podProperties = podProperties ?: throw PulumiNullFieldException("podProperties"),
    )
}
