@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containers Properties of the container that's used on the Amazon EKS pod. See containers below.
 * @property dnsPolicy DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
 * @property hostNetwork Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
 * @property imagePullSecrets List of Kubernetes secret resources. See `image_pull_secret` below.
 * @property metadata Metadata about the Kubernetes pod.
 * @property serviceAccountName Name of the service account that's used to run the pod.
 * @property volumes Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
 */
public data class JobDefinitionEksPropertiesPodPropertiesArgs(
    public val containers: Output<JobDefinitionEksPropertiesPodPropertiesContainersArgs>,
    public val dnsPolicy: Output<String>? = null,
    public val hostNetwork: Output<Boolean>? = null,
    public val imagePullSecrets: Output<List<JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs>>? = null,
    public val metadata: Output<JobDefinitionEksPropertiesPodPropertiesMetadataArgs>? = null,
    public val serviceAccountName: Output<String>? = null,
    public val volumes: Output<List<JobDefinitionEksPropertiesPodPropertiesVolumeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesArgs.builder()
            .containers(containers.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dnsPolicy(dnsPolicy?.applyValue({ args0 -> args0 }))
            .hostNetwork(hostNetwork?.applyValue({ args0 -> args0 }))
            .imagePullSecrets(
                imagePullSecrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metadata(metadata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceAccountName(serviceAccountName?.applyValue({ args0 -> args0 }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesArgsBuilder internal constructor() {
    private var containers: Output<JobDefinitionEksPropertiesPodPropertiesContainersArgs>? = null

    private var dnsPolicy: Output<String>? = null

    private var hostNetwork: Output<Boolean>? = null

    private var imagePullSecrets:
        Output<List<JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs>>? = null

    private var metadata: Output<JobDefinitionEksPropertiesPodPropertiesMetadataArgs>? = null

    private var serviceAccountName: Output<String>? = null

    private var volumes: Output<List<JobDefinitionEksPropertiesPodPropertiesVolumeArgs>>? = null

    /**
     * @param value Properties of the container that's used on the Amazon EKS pod. See containers below.
     */
    @JvmName("ayfavytmwfpfmjdw")
    public suspend fun containers(`value`: Output<JobDefinitionEksPropertiesPodPropertiesContainersArgs>) {
        this.containers = value
    }

    /**
     * @param value DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
     */
    @JvmName("xjjsjeppblotaikt")
    public suspend fun dnsPolicy(`value`: Output<String>) {
        this.dnsPolicy = value
    }

    /**
     * @param value Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
     */
    @JvmName("hyqhydesqsnjukcc")
    public suspend fun hostNetwork(`value`: Output<Boolean>) {
        this.hostNetwork = value
    }

    /**
     * @param value List of Kubernetes secret resources. See `image_pull_secret` below.
     */
    @JvmName("igotpxiibnpwdraj")
    public suspend fun imagePullSecrets(`value`: Output<List<JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs>>) {
        this.imagePullSecrets = value
    }

    @JvmName("yfdwrihutobbpvnq")
    public suspend fun imagePullSecrets(vararg values: Output<JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs>) {
        this.imagePullSecrets = Output.all(values.asList())
    }

    /**
     * @param values List of Kubernetes secret resources. See `image_pull_secret` below.
     */
    @JvmName("aihmlqaiuorvdjxl")
    public suspend fun imagePullSecrets(values: List<Output<JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs>>) {
        this.imagePullSecrets = Output.all(values)
    }

    /**
     * @param value Metadata about the Kubernetes pod.
     */
    @JvmName("ohqemdcxmpxkyhqg")
    public suspend fun metadata(`value`: Output<JobDefinitionEksPropertiesPodPropertiesMetadataArgs>) {
        this.metadata = value
    }

    /**
     * @param value Name of the service account that's used to run the pod.
     */
    @JvmName("qxlunhnpppsmibsw")
    public suspend fun serviceAccountName(`value`: Output<String>) {
        this.serviceAccountName = value
    }

    /**
     * @param value Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
     */
    @JvmName("xsqepqmdfgrgdbye")
    public suspend fun volumes(`value`: Output<List<JobDefinitionEksPropertiesPodPropertiesVolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("xcktucxfmbvsfagw")
    public suspend fun volumes(vararg values: Output<JobDefinitionEksPropertiesPodPropertiesVolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
     */
    @JvmName("lhtjautywpictnoa")
    public suspend fun volumes(values: List<Output<JobDefinitionEksPropertiesPodPropertiesVolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value Properties of the container that's used on the Amazon EKS pod. See containers below.
     */
    @JvmName("auxtsnkbhwnuxnty")
    public suspend fun containers(`value`: JobDefinitionEksPropertiesPodPropertiesContainersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument Properties of the container that's used on the Amazon EKS pod. See containers below.
     */
    @JvmName("qafpkoikpxhxofvt")
    public suspend fun containers(argument: suspend JobDefinitionEksPropertiesPodPropertiesContainersArgsBuilder.() -> Unit) {
        val toBeMapped = JobDefinitionEksPropertiesPodPropertiesContainersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param value DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
     */
    @JvmName("hsnsqlstjowjinnt")
    public suspend fun dnsPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsPolicy = mapped
    }

    /**
     * @param value Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
     */
    @JvmName("hgkwmsmdbusbqseq")
    public suspend fun hostNetwork(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNetwork = mapped
    }

    /**
     * @param value List of Kubernetes secret resources. See `image_pull_secret` below.
     */
    @JvmName("jscbiohknoagsmab")
    public suspend fun imagePullSecrets(`value`: List<JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullSecrets = mapped
    }

    /**
     * @param argument List of Kubernetes secret resources. See `image_pull_secret` below.
     */
    @JvmName("jvbmoshyhrfxaixa")
    public suspend fun imagePullSecrets(argument: List<suspend JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.imagePullSecrets = mapped
    }

    /**
     * @param argument List of Kubernetes secret resources. See `image_pull_secret` below.
     */
    @JvmName("uybexqcfuydbmgce")
    public suspend fun imagePullSecrets(vararg argument: suspend JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.imagePullSecrets = mapped
    }

    /**
     * @param argument List of Kubernetes secret resources. See `image_pull_secret` below.
     */
    @JvmName("cwhdrhagoxotebog")
    public suspend fun imagePullSecrets(argument: suspend JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.imagePullSecrets = mapped
    }

    /**
     * @param values List of Kubernetes secret resources. See `image_pull_secret` below.
     */
    @JvmName("lcywewaddlwnusqt")
    public suspend fun imagePullSecrets(vararg values: JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imagePullSecrets = mapped
    }

    /**
     * @param value Metadata about the Kubernetes pod.
     */
    @JvmName("fgreykxxqubayaji")
    public suspend fun metadata(`value`: JobDefinitionEksPropertiesPodPropertiesMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Metadata about the Kubernetes pod.
     */
    @JvmName("rawuubrcgffgaenf")
    public suspend fun metadata(argument: suspend JobDefinitionEksPropertiesPodPropertiesMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = JobDefinitionEksPropertiesPodPropertiesMetadataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param value Name of the service account that's used to run the pod.
     */
    @JvmName("nhtaoqqpxibianko")
    public suspend fun serviceAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountName = mapped
    }

    /**
     * @param value Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
     */
    @JvmName("itndrmbvgdgsougn")
    public suspend fun volumes(`value`: List<JobDefinitionEksPropertiesPodPropertiesVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
     */
    @JvmName("eerscrvfxcdpdhyy")
    public suspend fun volumes(argument: List<suspend JobDefinitionEksPropertiesPodPropertiesVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesVolumeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
     */
    @JvmName("snivrxrotedhmgxl")
    public suspend fun volumes(vararg argument: suspend JobDefinitionEksPropertiesPodPropertiesVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesVolumeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
     */
    @JvmName("fwwmasakhsmomore")
    public suspend fun volumes(argument: suspend JobDefinitionEksPropertiesPodPropertiesVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JobDefinitionEksPropertiesPodPropertiesVolumeArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
     */
    @JvmName("iergobmvhaqjkjtr")
    public suspend fun volumes(vararg values: JobDefinitionEksPropertiesPodPropertiesVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesArgs =
        JobDefinitionEksPropertiesPodPropertiesArgs(
            containers = containers ?: throw PulumiNullFieldException("containers"),
            dnsPolicy = dnsPolicy,
            hostNetwork = hostNetwork,
            imagePullSecrets = imagePullSecrets,
            metadata = metadata,
            serviceAccountName = serviceAccountName,
            volumes = volumes,
        )
}
