@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
 * @property commands Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
 * @property envs Environment variables to pass to a container. See EKS Environment below.
 * @property image Docker image used to start the container.
 * @property imagePullPolicy Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
 * @property name Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
 * @property resources Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
 * @property securityContext Security context for a job.
 * @property volumeMounts Volume mounts for the container.
 */
public data class JobDefinitionEksPropertiesPodPropertiesContainersArgs(
    public val args: Output<List<String>>? = null,
    public val commands: Output<List<String>>? = null,
    public val envs: Output<List<JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs>>? = null,
    public val image: Output<String>,
    public val imagePullPolicy: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resources: Output<JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs>? =
        null,
    public val securityContext: Output<JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs>? = null,
    public val volumeMounts: Output<List<JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .envs(envs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .image(image.applyValue({ args0 -> args0 }))
            .imagePullPolicy(imagePullPolicy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityContext(securityContext?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesContainersArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesContainersArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var commands: Output<List<String>>? = null

    private var envs: Output<List<JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs>>? = null

    private var image: Output<String>? = null

    private var imagePullPolicy: Output<String>? = null

    private var name: Output<String>? = null

    private var resources: Output<JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs>? =
        null

    private var securityContext:
        Output<JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs>? = null

    private var volumeMounts:
        Output<List<JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs>>? = null

    /**
     * @param value Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
     */
    @JvmName("rgtxfkidmxqfohat")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("yaocxupwgfsginys")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
     */
    @JvmName("ajfaeyyrvjmxpsco")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
     */
    @JvmName("kqcnihrvcjycjcir")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("cucfyfuleexvaphe")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
     */
    @JvmName("lxkdclefobqemjxx")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Environment variables to pass to a container. See EKS Environment below.
     */
    @JvmName("tmengexeeumluljj")
    public suspend fun envs(`value`: Output<List<JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs>>) {
        this.envs = value
    }

    @JvmName("xguvmifjirtsspsw")
    public suspend fun envs(vararg values: Output<JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs>) {
        this.envs = Output.all(values.asList())
    }

    /**
     * @param values Environment variables to pass to a container. See EKS Environment below.
     */
    @JvmName("mdsltabgneygxxlx")
    public suspend fun envs(values: List<Output<JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs>>) {
        this.envs = Output.all(values)
    }

    /**
     * @param value Docker image used to start the container.
     */
    @JvmName("yygfkfkdebqpoygm")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
     */
    @JvmName("fgwjdfbxkpvltdkx")
    public suspend fun imagePullPolicy(`value`: Output<String>) {
        this.imagePullPolicy = value
    }

    /**
     * @param value Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
     */
    @JvmName("jdkxotgihjervysn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
     */
    @JvmName("rhabyqfcwjkidoau")
    public suspend fun resources(`value`: Output<JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs>) {
        this.resources = value
    }

    /**
     * @param value Security context for a job.
     */
    @JvmName("skbjhgrrgnrrhqqr")
    public suspend fun securityContext(`value`: Output<JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs>) {
        this.securityContext = value
    }

    /**
     * @param value Volume mounts for the container.
     */
    @JvmName("yixecelqptywfmfl")
    public suspend fun volumeMounts(`value`: Output<List<JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("cvscnhlwfxyrlxyp")
    public suspend fun volumeMounts(vararg values: Output<JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values Volume mounts for the container.
     */
    @JvmName("bikubyuostnycgpk")
    public suspend fun volumeMounts(values: List<Output<JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
     */
    @JvmName("jrduwsiocfwubhbf")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
     */
    @JvmName("lexympsxjkyadhld")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
     */
    @JvmName("gwdnckmrfpqdpsov")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
     */
    @JvmName("adodxfdvmtrnalyl")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value Environment variables to pass to a container. See EKS Environment below.
     */
    @JvmName("xjswhajdkdeiynmr")
    public suspend fun envs(`value`: List<JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envs = mapped
    }

    /**
     * @param argument Environment variables to pass to a container. See EKS Environment below.
     */
    @JvmName("xlmhrfxnwxkeyiyk")
    public suspend fun envs(argument: List<suspend JobDefinitionEksPropertiesPodPropertiesContainersEnvArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesContainersEnvArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envs = mapped
    }

    /**
     * @param argument Environment variables to pass to a container. See EKS Environment below.
     */
    @JvmName("paosvkdrsgwebdlr")
    public suspend fun envs(vararg argument: suspend JobDefinitionEksPropertiesPodPropertiesContainersEnvArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesContainersEnvArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envs = mapped
    }

    /**
     * @param argument Environment variables to pass to a container. See EKS Environment below.
     */
    @JvmName("qhpdrnncyxonqpfm")
    public suspend fun envs(argument: suspend JobDefinitionEksPropertiesPodPropertiesContainersEnvArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                JobDefinitionEksPropertiesPodPropertiesContainersEnvArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.envs = mapped
    }

    /**
     * @param values Environment variables to pass to a container. See EKS Environment below.
     */
    @JvmName("dfbqbphopanwfgfw")
    public suspend fun envs(vararg values: JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envs = mapped
    }

    /**
     * @param value Docker image used to start the container.
     */
    @JvmName("oqyfbundrojferpx")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
     */
    @JvmName("wqytsridqtwymbpm")
    public suspend fun imagePullPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullPolicy = mapped
    }

    /**
     * @param value Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
     */
    @JvmName("rughcbfsrkgjdbkp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
     */
    @JvmName("sktvwweogodqvoph")
    public suspend fun resources(`value`: JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
     */
    @JvmName("gthiupaibfuaubpk")
    public suspend fun resources(argument: suspend JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value Security context for a job.
     */
    @JvmName("mmrgontddanvfjqx")
    public suspend fun securityContext(`value`: JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContext = mapped
    }

    /**
     * @param argument Security context for a job.
     */
    @JvmName("lrliquwybdvntxuk")
    public suspend fun securityContext(argument: suspend JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.securityContext = mapped
    }

    /**
     * @param value Volume mounts for the container.
     */
    @JvmName("frumoccwwtmppcjh")
    public suspend fun volumeMounts(`value`: List<JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument Volume mounts for the container.
     */
    @JvmName("qqebnthcaylmgrkk")
    public suspend fun volumeMounts(argument: List<suspend JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Volume mounts for the container.
     */
    @JvmName("cwjqfdecqtsucfpp")
    public suspend fun volumeMounts(vararg argument: suspend JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Volume mounts for the container.
     */
    @JvmName("jhbxvyuxrklvjoqu")
    public suspend fun volumeMounts(argument: suspend JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values Volume mounts for the container.
     */
    @JvmName("egdrgecuwbmmcwnm")
    public suspend fun volumeMounts(vararg values: JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesContainersArgs =
        JobDefinitionEksPropertiesPodPropertiesContainersArgs(
            args = args,
            commands = commands,
            envs = envs,
            image = image ?: throw PulumiNullFieldException("image"),
            imagePullPolicy = imagePullPolicy,
            name = name,
            resources = resources,
            securityContext = securityContext,
            volumeMounts = volumeMounts,
        )
}
