@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the job definition.
 * @property value Value of the environment variable.
 */
public data class JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesContainersEnvArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the job definition.
     */
    @JvmName("lccxpbmocwqqqpmb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of the environment variable.
     */
    @JvmName("xgcyhudusejvxgsq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the job definition.
     */
    @JvmName("afwijblxarstctxj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of the environment variable.
     */
    @JvmName("dfxevawwrscgnhjk")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs =
        JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
