@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property limits
 * @property requests
 */
public data class JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs(
    public val limits: Output<Map<String, String>>? = null,
    public val requests: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs.builder()
            .limits(limits?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .requests(
                requests?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgsBuilder internal constructor() {
    private var limits: Output<Map<String, String>>? = null

    private var requests: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("ndoopgrawfnxreqp")
    public suspend fun limits(`value`: Output<Map<String, String>>) {
        this.limits = value
    }

    /**
     * @param value
     */
    @JvmName("lthotkqnmjpnvija")
    public suspend fun requests(`value`: Output<Map<String, String>>) {
        this.requests = value
    }

    /**
     * @param value
     */
    @JvmName("prsfhtryaipufook")
    public suspend fun limits(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param values
     */
    @JvmName("grvbcvqvwgiaoioj")
    public fun limits(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param value
     */
    @JvmName("uxlcpngoqixlccag")
    public suspend fun requests(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param values
     */
    @JvmName("vnykertxyrnfvlow")
    public fun requests(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs =
        JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs(
            limits = limits,
            requests = requests,
        )
}
