@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privileged
 * @property readOnlyRootFileSystem
 * @property runAsGroup
 * @property runAsNonRoot
 * @property runAsUser
 */
public data class JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs(
    public val privileged: Output<Boolean>? = null,
    public val readOnlyRootFileSystem: Output<Boolean>? = null,
    public val runAsGroup: Output<Int>? = null,
    public val runAsNonRoot: Output<Boolean>? = null,
    public val runAsUser: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs.builder()
            .privileged(privileged?.applyValue({ args0 -> args0 }))
            .readOnlyRootFileSystem(readOnlyRootFileSystem?.applyValue({ args0 -> args0 }))
            .runAsGroup(runAsGroup?.applyValue({ args0 -> args0 }))
            .runAsNonRoot(runAsNonRoot?.applyValue({ args0 -> args0 }))
            .runAsUser(runAsUser?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgsBuilder internal constructor() {
    private var privileged: Output<Boolean>? = null

    private var readOnlyRootFileSystem: Output<Boolean>? = null

    private var runAsGroup: Output<Int>? = null

    private var runAsNonRoot: Output<Boolean>? = null

    private var runAsUser: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("hkwukgvjgailbyve")
    public suspend fun privileged(`value`: Output<Boolean>) {
        this.privileged = value
    }

    /**
     * @param value
     */
    @JvmName("smlbmcvwbnongusa")
    public suspend fun readOnlyRootFileSystem(`value`: Output<Boolean>) {
        this.readOnlyRootFileSystem = value
    }

    /**
     * @param value
     */
    @JvmName("wgpngfndippdeebi")
    public suspend fun runAsGroup(`value`: Output<Int>) {
        this.runAsGroup = value
    }

    /**
     * @param value
     */
    @JvmName("kpwlkirrvfreboka")
    public suspend fun runAsNonRoot(`value`: Output<Boolean>) {
        this.runAsNonRoot = value
    }

    /**
     * @param value
     */
    @JvmName("pciqvchkeyyntnjo")
    public suspend fun runAsUser(`value`: Output<Int>) {
        this.runAsUser = value
    }

    /**
     * @param value
     */
    @JvmName("oqcjunwqlsikgwkb")
    public suspend fun privileged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privileged = mapped
    }

    /**
     * @param value
     */
    @JvmName("aofaarwxnlvmuvyv")
    public suspend fun readOnlyRootFileSystem(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyRootFileSystem = mapped
    }

    /**
     * @param value
     */
    @JvmName("ebiilraiieisfstb")
    public suspend fun runAsGroup(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktfxhwdasamdpphf")
    public suspend fun runAsNonRoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsNonRoot = mapped
    }

    /**
     * @param value
     */
    @JvmName("kxucyqxlwecthhac")
    public suspend fun runAsUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsUser = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs =
        JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs(
            privileged = privileged,
            readOnlyRootFileSystem = readOnlyRootFileSystem,
            runAsGroup = runAsGroup,
            runAsNonRoot = runAsNonRoot,
            runAsUser = runAsUser,
        )
}
