@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountPath
 * @property name Name of the job definition.
 * @property readOnly
 */
public data class JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs(
    public val mountPath: Output<String>,
    public val name: Output<String>,
    public val readOnly: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs.builder()
            .mountPath(mountPath.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var name: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("tgityykwbtmkvnvh")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value Name of the job definition.
     */
    @JvmName("potrdonvnonuyhsd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("pokusrpcjwiefkmj")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value
     */
    @JvmName("myntirbqdypvfgnm")
    public suspend fun mountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value Name of the job definition.
     */
    @JvmName("avodyvdhhrwguait")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("jsyxjnexhbhlsodl")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs =
        JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs(
            mountPath = mountPath ?: throw PulumiNullFieldException("mountPath"),
            name = name ?: throw PulumiNullFieldException("name"),
            readOnly = readOnly,
        )
}
