@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property emptyDir
 * @property hostPath
 * @property name Name of the job definition.
 * @property secret
 */
public data class JobDefinitionEksPropertiesPodPropertiesVolumeArgs(
    public val emptyDir: Output<JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs>? = null,
    public val hostPath: Output<JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs>? = null,
    public val name: Output<String>? = null,
    public val secret: Output<JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeArgs.builder()
            .emptyDir(emptyDir?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostPath(hostPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .secret(secret?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesVolumeArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesVolumeArgsBuilder internal constructor() {
    private var emptyDir: Output<JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs>? = null

    private var hostPath: Output<JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs>? = null

    private var name: Output<String>? = null

    private var secret: Output<JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs>? = null

    /**
     * @param value
     */
    @JvmName("utjjjeavwnskrblx")
    public suspend fun emptyDir(`value`: Output<JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs>) {
        this.emptyDir = value
    }

    /**
     * @param value
     */
    @JvmName("yvwnmxwwgetellsg")
    public suspend fun hostPath(`value`: Output<JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs>) {
        this.hostPath = value
    }

    /**
     * @param value Name of the job definition.
     */
    @JvmName("lgcidlpmagiwtcef")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("auqjrgdtehadhhnu")
    public suspend fun secret(`value`: Output<JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs>) {
        this.secret = value
    }

    /**
     * @param value
     */
    @JvmName("todjnsbloyejjopp")
    public suspend fun emptyDir(`value`: JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emptyDir = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vlbslhjbqyhckvnu")
    public suspend fun emptyDir(argument: suspend JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.emptyDir = mapped
    }

    /**
     * @param value
     */
    @JvmName("ejjaskljxvotypna")
    public suspend fun hostPath(`value`: JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPath = mapped
    }

    /**
     * @param argument
     */
    @JvmName("msbjnwqrbputkbqo")
    public suspend fun hostPath(argument: suspend JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.hostPath = mapped
    }

    /**
     * @param value Name of the job definition.
     */
    @JvmName("fpxpppecslmbpfie")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("twsfowxrirmuqpsw")
    public suspend fun secret(`value`: JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cmjerpmhqumgxryn")
    public suspend fun secret(argument: suspend JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgsBuilder.() -> Unit) {
        val toBeMapped = JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.secret = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesVolumeArgs =
        JobDefinitionEksPropertiesPodPropertiesVolumeArgs(
            emptyDir = emptyDir,
            hostPath = hostPath,
            name = name,
            secret = secret,
        )
}
