@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property medium Medium to store the volume. The default value is an empty string, which uses the storage of the node.
 * @property sizeLimit Maximum size of the volume. By default, there's no maximum size defined.
 */
public data class JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs(
    public val medium: Output<String>? = null,
    public val sizeLimit: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs.builder()
            .medium(medium?.applyValue({ args0 -> args0 }))
            .sizeLimit(sizeLimit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgsBuilder internal constructor() {
    private var medium: Output<String>? = null

    private var sizeLimit: Output<String>? = null

    /**
     * @param value Medium to store the volume. The default value is an empty string, which uses the storage of the node.
     */
    @JvmName("xlusqywvnwnkuixi")
    public suspend fun medium(`value`: Output<String>) {
        this.medium = value
    }

    /**
     * @param value Maximum size of the volume. By default, there's no maximum size defined.
     */
    @JvmName("pivhfktdmwqswycb")
    public suspend fun sizeLimit(`value`: Output<String>) {
        this.sizeLimit = value
    }

    /**
     * @param value Medium to store the volume. The default value is an empty string, which uses the storage of the node.
     */
    @JvmName("naxyyjjbrvyknlox")
    public suspend fun medium(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.medium = mapped
    }

    /**
     * @param value Maximum size of the volume. By default, there's no maximum size defined.
     */
    @JvmName("kjyowajkqitluytr")
    public suspend fun sizeLimit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeLimit = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs =
        JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs(
            medium = medium,
            sizeLimit = sizeLimit ?: throw PulumiNullFieldException("sizeLimit"),
        )
}
