@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property path Path of the file or directory on the host to mount into containers on the pod.
 */
public data class JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs(
    public val path: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs.builder()
            .path(path.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    /**
     * @param value Path of the file or directory on the host to mount into containers on the pod.
     */
    @JvmName("dcwgbsodwprbmcdb")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Path of the file or directory on the host to mount into containers on the pod.
     */
    @JvmName("vbwmjftpteisarmy")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs =
        JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs(
            path = path ?: throw PulumiNullFieldException("path"),
        )
}
