@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property optional Whether the secret or the secret's keys must be defined.
 * @property secretName Name of the secret. The name must be allowed as a DNS subdomain name.
 */
public data class JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs(
    public val optional: Output<Boolean>? = null,
    public val secretName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs.builder()
            .optional(optional?.applyValue({ args0 -> args0 }))
            .secretName(secretName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs].
 */
@PulumiTagMarker
public class JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgsBuilder internal constructor() {
    private var optional: Output<Boolean>? = null

    private var secretName: Output<String>? = null

    /**
     * @param value Whether the secret or the secret's keys must be defined.
     */
    @JvmName("rbcvynhreljiudkn")
    public suspend fun optional(`value`: Output<Boolean>) {
        this.optional = value
    }

    /**
     * @param value Name of the secret. The name must be allowed as a DNS subdomain name.
     */
    @JvmName("ogkxjyfvdiyvdpam")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value Whether the secret or the secret's keys must be defined.
     */
    @JvmName("nqqwuabnxlgmxdfb")
    public suspend fun optional(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optional = mapped
    }

    /**
     * @param value Name of the secret. The name must be allowed as a DNS subdomain name.
     */
    @JvmName("sfkyvfpgkxbyncik")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    internal fun build(): JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs =
        JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs(
            optional = optional,
            secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        )
}
