@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
 * @property onExitCode Glob pattern to match against the decimal representation of the exit code returned for a job.
 * @property onReason Glob pattern to match against the reason returned for a job.
 * @property onStatusReason Glob pattern to match against the status reason returned for a job.
 */
public data class JobDefinitionRetryStrategyEvaluateOnExitArgs(
    public val action: Output<String>,
    public val onExitCode: Output<String>? = null,
    public val onReason: Output<String>? = null,
    public val onStatusReason: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .onExitCode(onExitCode?.applyValue({ args0 -> args0 }))
            .onReason(onReason?.applyValue({ args0 -> args0 }))
            .onStatusReason(onStatusReason?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionRetryStrategyEvaluateOnExitArgs].
 */
@PulumiTagMarker
public class JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var onExitCode: Output<String>? = null

    private var onReason: Output<String>? = null

    private var onStatusReason: Output<String>? = null

    /**
     * @param value Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
     */
    @JvmName("wpmthmcxsomwuxks")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Glob pattern to match against the decimal representation of the exit code returned for a job.
     */
    @JvmName("upkaxiunowuccvvv")
    public suspend fun onExitCode(`value`: Output<String>) {
        this.onExitCode = value
    }

    /**
     * @param value Glob pattern to match against the reason returned for a job.
     */
    @JvmName("qnkgrqsldycirvhy")
    public suspend fun onReason(`value`: Output<String>) {
        this.onReason = value
    }

    /**
     * @param value Glob pattern to match against the status reason returned for a job.
     */
    @JvmName("fnxjgljtmnsumpqh")
    public suspend fun onStatusReason(`value`: Output<String>) {
        this.onStatusReason = value
    }

    /**
     * @param value Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
     */
    @JvmName("dlffcgsrnaretrqy")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Glob pattern to match against the decimal representation of the exit code returned for a job.
     */
    @JvmName("klvveuvvcrnbtqup")
    public suspend fun onExitCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onExitCode = mapped
    }

    /**
     * @param value Glob pattern to match against the reason returned for a job.
     */
    @JvmName("jbdidbiuvuifxods")
    public suspend fun onReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onReason = mapped
    }

    /**
     * @param value Glob pattern to match against the status reason returned for a job.
     */
    @JvmName("aeilsbkmgedjcfwh")
    public suspend fun onStatusReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onStatusReason = mapped
    }

    internal fun build(): JobDefinitionRetryStrategyEvaluateOnExitArgs =
        JobDefinitionRetryStrategyEvaluateOnExitArgs(
            action = action ?: throw PulumiNullFieldException("action"),
            onExitCode = onExitCode,
            onReason = onReason,
            onStatusReason = onStatusReason,
        )
}
