@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attemptDurationSeconds Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
 */
public data class JobDefinitionTimeoutArgs(
    public val attemptDurationSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionTimeoutArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionTimeoutArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionTimeoutArgs.builder()
            .attemptDurationSeconds(attemptDurationSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionTimeoutArgs].
 */
@PulumiTagMarker
public class JobDefinitionTimeoutArgsBuilder internal constructor() {
    private var attemptDurationSeconds: Output<Int>? = null

    /**
     * @param value Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
     */
    @JvmName("jsmytmaadwvrdvba")
    public suspend fun attemptDurationSeconds(`value`: Output<Int>) {
        this.attemptDurationSeconds = value
    }

    /**
     * @param value Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
     */
    @JvmName("bndvmfydqkfxwarx")
    public suspend fun attemptDurationSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attemptDurationSeconds = mapped
    }

    internal fun build(): JobDefinitionTimeoutArgs = JobDefinitionTimeoutArgs(
        attemptDurationSeconds = attemptDurationSeconds,
    )
}
