@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property computeEnvironment The Amazon Resource Name (ARN) of the compute environment.
 * @property order The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
 */
public data class JobQueueComputeEnvironmentOrderArgs(
    public val computeEnvironment: Output<String>,
    public val order: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs =
        com.pulumi.aws.batch.inputs.JobQueueComputeEnvironmentOrderArgs.builder()
            .computeEnvironment(computeEnvironment.applyValue({ args0 -> args0 }))
            .order(order.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobQueueComputeEnvironmentOrderArgs].
 */
@PulumiTagMarker
public class JobQueueComputeEnvironmentOrderArgsBuilder internal constructor() {
    private var computeEnvironment: Output<String>? = null

    private var order: Output<Int>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the compute environment.
     */
    @JvmName("arjuhmvndvvnnqgt")
    public suspend fun computeEnvironment(`value`: Output<String>) {
        this.computeEnvironment = value
    }

    /**
     * @param value The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
     */
    @JvmName("jmgioraibgfwvlii")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the compute environment.
     */
    @JvmName("jcrtdfwahqpynlfj")
    public suspend fun computeEnvironment(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeEnvironment = mapped
    }

    /**
     * @param value The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
     */
    @JvmName("urpehatsdpuwfpff")
    public suspend fun order(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    internal fun build(): JobQueueComputeEnvironmentOrderArgs = JobQueueComputeEnvironmentOrderArgs(
        computeEnvironment = computeEnvironment ?: throw PulumiNullFieldException("computeEnvironment"),
        order = order ?: throw PulumiNullFieldException("order"),
    )
}
