@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property allocationStrategy The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property bidPercentage Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property desiredVcpus The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property ec2Configurations Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
 * @property ec2KeyPair The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property imageId The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
 * @property instanceRole The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property instanceTypes A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property launchTemplate The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property maxVcpus The maximum number of EC2 vCPUs that an environment can reach.
 * @property minVcpus The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property placementGroup The Amazon EC2 placement group to associate with your compute resources.
 * @property securityGroupIds A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
 * @property spotIamFleetRole The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property subnets A list of VPC subnets into which the compute resources are launched.
 * @property tags Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property type The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
 */
public data class ComputeEnvironmentComputeResources(
    public val allocationStrategy: String? = null,
    public val bidPercentage: Int? = null,
    public val desiredVcpus: Int? = null,
    public val ec2Configurations: List<ComputeEnvironmentComputeResourcesEc2Configuration>? = null,
    public val ec2KeyPair: String? = null,
    public val imageId: String? = null,
    public val instanceRole: String? = null,
    public val instanceTypes: List<String>? = null,
    public val launchTemplate: ComputeEnvironmentComputeResourcesLaunchTemplate? = null,
    public val maxVcpus: Int,
    public val minVcpus: Int? = null,
    public val placementGroup: String? = null,
    public val securityGroupIds: List<String>? = null,
    public val spotIamFleetRole: String? = null,
    public val subnets: List<String>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.ComputeEnvironmentComputeResources): ComputeEnvironmentComputeResources = ComputeEnvironmentComputeResources(
            allocationStrategy = javaType.allocationStrategy().map({ args0 -> args0 }).orElse(null),
            bidPercentage = javaType.bidPercentage().map({ args0 -> args0 }).orElse(null),
            desiredVcpus = javaType.desiredVcpus().map({ args0 -> args0 }).orElse(null),
            ec2Configurations = javaType.ec2Configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.ComputeEnvironmentComputeResourcesEc2Configuration.Companion.toKotlin(args0)
                })
            }),
            ec2KeyPair = javaType.ec2KeyPair().map({ args0 -> args0 }).orElse(null),
            imageId = javaType.imageId().map({ args0 -> args0 }).orElse(null),
            instanceRole = javaType.instanceRole().map({ args0 -> args0 }).orElse(null),
            instanceTypes = javaType.instanceTypes().map({ args0 -> args0 }),
            launchTemplate = javaType.launchTemplate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.ComputeEnvironmentComputeResourcesLaunchTemplate.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxVcpus = javaType.maxVcpus(),
            minVcpus = javaType.minVcpus().map({ args0 -> args0 }).orElse(null),
            placementGroup = javaType.placementGroup().map({ args0 -> args0 }).orElse(null),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            spotIamFleetRole = javaType.spotIamFleetRole().map({ args0 -> args0 }).orElse(null),
            subnets = javaType.subnets().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
