@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property launchTemplateId ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
 * @property launchTemplateName Name of the launch template.
 * @property version The version number of the launch template. Default: The default version of the launch template.
 */
public data class ComputeEnvironmentComputeResourcesLaunchTemplate(
    public val launchTemplateId: String? = null,
    public val launchTemplateName: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.ComputeEnvironmentComputeResourcesLaunchTemplate): ComputeEnvironmentComputeResourcesLaunchTemplate =
            ComputeEnvironmentComputeResourcesLaunchTemplate(
                launchTemplateId = javaType.launchTemplateId().map({ args0 -> args0 }).orElse(null),
                launchTemplateName = javaType.launchTemplateName().map({ args0 -> args0 }).orElse(null),
                version = javaType.version().map({ args0 -> args0 }).orElse(null),
            )
    }
}
