@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eksClusterArn The Amazon Resource Name (ARN) of the Amazon EKS cluster.
 * @property kubernetesNamespace The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
 */
public data class ComputeEnvironmentEksConfiguration(
    public val eksClusterArn: String,
    public val kubernetesNamespace: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.ComputeEnvironmentEksConfiguration): ComputeEnvironmentEksConfiguration = ComputeEnvironmentEksConfiguration(
            eksClusterArn = javaType.eksClusterArn(),
            kubernetesNamespace = javaType.kubernetesNamespace(),
        )
    }
}
