@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property jobExecutionTimeoutMinutes Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
 * @property terminateJobsOnUpdate Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
 */
public data class ComputeEnvironmentUpdatePolicy(
    public val jobExecutionTimeoutMinutes: Int,
    public val terminateJobsOnUpdate: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.ComputeEnvironmentUpdatePolicy): ComputeEnvironmentUpdatePolicy = ComputeEnvironmentUpdatePolicy(
            jobExecutionTimeoutMinutes = javaType.jobExecutionTimeoutMinutes(),
            terminateJobsOnUpdate = javaType.terminateJobsOnUpdate(),
        )
    }
}
