@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containers The properties of the container that's used on the Amazon EKS pod. Array of EksContainer objects.
 * @property dnsPolicy The DNS policy for the pod. The default value is ClusterFirst. If the hostNetwork parameter is not specified, the default is ClusterFirstWithHostNet. ClusterFirst indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node.
 * @property hostNetwork Indicates if the pod uses the hosts' network IP address. The default value is true. Setting this to false enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
 * @property metadatas Metadata about the Kubernetes pod.
 * @property serviceAccountName The name of the service account that's used to run the pod.
 * @property volumes A list of data volumes used in a job.
 */
public data class GetJobDefinitionEksPropertyPodProperty(
    public val containers: List<GetJobDefinitionEksPropertyPodPropertyContainer>,
    public val dnsPolicy: String,
    public val hostNetwork: Boolean,
    public val metadatas: List<GetJobDefinitionEksPropertyPodPropertyMetadata>,
    public val serviceAccountName: Boolean,
    public val volumes: List<GetJobDefinitionEksPropertyPodPropertyVolume>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionEksPropertyPodProperty): GetJobDefinitionEksPropertyPodProperty = GetJobDefinitionEksPropertyPodProperty(
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyContainer.Companion.toKotlin(args0)
                })
            }),
            dnsPolicy = javaType.dnsPolicy(),
            hostNetwork = javaType.hostNetwork(),
            metadatas = javaType.metadatas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyMetadata.Companion.toKotlin(args0)
                })
            }),
            serviceAccountName = javaType.serviceAccountName(),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyVolume.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
