@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args An array of arguments to the entrypoint
 * @property commands The command that's passed to the container.
 * @property envs The environment variables to pass to a container.  Array of EksContainerEnvironmentVariable objects.
 * @property image The image used to start a container.
 * @property imagePullPolicy The image pull policy for the container.
 * @property name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
 * @property resources The type and amount of resources to assign to a container.
 * @property securityContexts The security context for a job.
 * @property volumeMounts The volume mounts for the container.
 */
public data class GetJobDefinitionEksPropertyPodPropertyContainer(
    public val args: List<String>,
    public val commands: List<String>,
    public val envs: List<GetJobDefinitionEksPropertyPodPropertyContainerEnv>,
    public val image: String,
    public val imagePullPolicy: String,
    public val name: String,
    public val resources: List<GetJobDefinitionEksPropertyPodPropertyContainerResource>,
    public val securityContexts: List<GetJobDefinitionEksPropertyPodPropertyContainerSecurityContext>,
    public val volumeMounts: List<GetJobDefinitionEksPropertyPodPropertyContainerVolumeMount>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionEksPropertyPodPropertyContainer): GetJobDefinitionEksPropertyPodPropertyContainer =
            GetJobDefinitionEksPropertyPodPropertyContainer(
                args = javaType.args().map({ args0 -> args0 }),
                commands = javaType.commands().map({ args0 -> args0 }),
                envs = javaType.envs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyContainerEnv.Companion.toKotlin(args0)
                    })
                }),
                image = javaType.image(),
                imagePullPolicy = javaType.imagePullPolicy(),
                name = javaType.name(),
                resources = javaType.resources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyContainerResource.Companion.toKotlin(args0)
                    })
                }),
                securityContexts = javaType.securityContexts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyContainerSecurityContext.Companion.toKotlin(args0)
                    })
                }),
                volumeMounts = javaType.volumeMounts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyContainerVolumeMount.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
