@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property privileged When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
 * @property readOnlyRootFileSystem
 * @property runAsGroup When this parameter is specified, the container is run as the specified group ID (gid). If this parameter isn't specified, the default is the group that's specified in the image metadata.
 * @property runAsNonRoot When this parameter is specified, the container is run as a user with a uid other than 0. If this parameter isn't specified, so such rule is enforced.
 * @property runAsUser When this parameter is specified, the container is run as the specified user ID (uid). If this parameter isn't specified, the default is the user that's specified in the image metadata.
 */
public data class GetJobDefinitionEksPropertyPodPropertyContainerSecurityContext(
    public val privileged: Boolean,
    public val readOnlyRootFileSystem: Boolean,
    public val runAsGroup: Int,
    public val runAsNonRoot: Boolean,
    public val runAsUser: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionEksPropertyPodPropertyContainerSecurityContext): GetJobDefinitionEksPropertyPodPropertyContainerSecurityContext =
            GetJobDefinitionEksPropertyPodPropertyContainerSecurityContext(
                privileged = javaType.privileged(),
                readOnlyRootFileSystem = javaType.readOnlyRootFileSystem(),
                runAsGroup = javaType.runAsGroup(),
                runAsNonRoot = javaType.runAsNonRoot(),
                runAsUser = javaType.runAsUser(),
            )
    }
}
