@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mountPath The path on the container where the volume is mounted.
 * @property name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
 * @property readOnly If this value is true, the container has read-only access to the volume.
 */
public data class GetJobDefinitionEksPropertyPodPropertyContainerVolumeMount(
    public val mountPath: String,
    public val name: String,
    public val readOnly: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionEksPropertyPodPropertyContainerVolumeMount): GetJobDefinitionEksPropertyPodPropertyContainerVolumeMount =
            GetJobDefinitionEksPropertyPodPropertyContainerVolumeMount(
                mountPath = javaType.mountPath(),
                name = javaType.name(),
                readOnly = javaType.readOnly(),
            )
    }
}
