@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property emptyDirs Specifies the configuration of a Kubernetes emptyDir volume.
 * @property hostPaths The path for the device on the host container instance.
 * @property name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
 * @property secrets Specifies the configuration of a Kubernetes secret volume.
 */
public data class GetJobDefinitionEksPropertyPodPropertyVolume(
    public val emptyDirs: List<GetJobDefinitionEksPropertyPodPropertyVolumeEmptyDir>,
    public val hostPaths: List<GetJobDefinitionEksPropertyPodPropertyVolumeHostPath>,
    public val name: String,
    public val secrets: List<GetJobDefinitionEksPropertyPodPropertyVolumeSecret>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionEksPropertyPodPropertyVolume): GetJobDefinitionEksPropertyPodPropertyVolume = GetJobDefinitionEksPropertyPodPropertyVolume(
            emptyDirs = javaType.emptyDirs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyVolumeEmptyDir.Companion.toKotlin(args0)
                })
            }),
            hostPaths = javaType.hostPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyVolumeHostPath.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionEksPropertyPodPropertyVolumeSecret.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
