@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property mainNode Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
 * @property nodeRangeProperties A list of node ranges and their properties that are associated with a multi-node parallel job.
 * @property numNodes The number of nodes that are associated with a multi-node parallel job.
 */
public data class GetJobDefinitionNodeProperty(
    public val mainNode: Int,
    public val nodeRangeProperties: List<GetJobDefinitionNodePropertyNodeRangeProperty>,
    public val numNodes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodeProperty): GetJobDefinitionNodeProperty = GetJobDefinitionNodeProperty(
            mainNode = javaType.mainNode(),
            nodeRangeProperties = javaType.nodeRangeProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionNodePropertyNodeRangeProperty.Companion.toKotlin(args0)
                })
            }),
            numNodes = javaType.numNodes(),
        )
    }
}
