@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property devices Any of the host devices to expose to the container.
 * @property initProcessEnabled If true, run an init process inside the container that forwards signals and reaps processes.
 * @property maxSwap The total amount of swap memory (in MiB) a container can use.
 * @property sharedMemorySize The value for the size (in MiB) of the `/dev/shm` volume.
 * @property swappiness You can use this parameter to tune a container's memory swappiness behavior.
 * @property tmpfs The container path, mount options, and size (in MiB) of the tmpfs mount.
 */
public data class GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameter(
    public val devices: List<GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDevice>,
    public val initProcessEnabled: Boolean,
    public val maxSwap: Int,
    public val sharedMemorySize: Int,
    public val swappiness: Int,
    public val tmpfs: List<GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpf>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameter): GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameter =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameter(
                devices = javaType.devices().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDevice.Companion.toKotlin(args0)
                    })
                }),
                initProcessEnabled = javaType.initProcessEnabled(),
                maxSwap = javaType.maxSwap(),
                sharedMemorySize = javaType.sharedMemorySize(),
                swappiness = javaType.swappiness(),
                tmpfs = javaType.tmpfs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpf.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
