@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerPath The absolute file path in the container where the tmpfs volume is mounted.
 * @property hostPath The path for the device on the host container instance.
 * @property permissions The explicit permissions to provide to the container for the device.
 */
public data class GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDevice(
    public val containerPath: String,
    public val hostPath: String,
    public val permissions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDevice): GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDevice =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDevice(
                containerPath = javaType.containerPath(),
                hostPath = javaType.hostPath(),
                permissions = javaType.permissions().map({ args0 -> args0 }),
            )
    }
}
