@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerPath The absolute file path in the container where the tmpfs volume is mounted.
 * @property mountOptions The list of tmpfs volume mount options.
 * @property size The size (in MiB) of the tmpfs volume.
 */
public data class GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpf(
    public val containerPath: String,
    public val mountOptions: List<String>,
    public val size: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpf): GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpf =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpf(
                containerPath = javaType.containerPath(),
                mountOptions = javaType.mountOptions().map({ args0 -> args0 }),
                size = javaType.size(),
            )
    }
}
