@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property logDriver The log driver to use for the container.
 * @property options The configuration options to send to the log driver.
 * @property secretOptions The secrets to pass to the log configuration.
 */
public data class GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfiguration(
    public val logDriver: String,
    public val options: Map<String, String>,
    public val secretOptions: List<GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOption>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfiguration): GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfiguration =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfiguration(
                logDriver = javaType.logDriver(),
                options = javaType.options().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                secretOptions = javaType.secretOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOption.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
