@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
 * @property valueFrom The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
 */
public data class
GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOption(
    public val name: String,
    public val valueFrom: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOption): GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOption =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOption(
                name = javaType.name(),
                valueFrom = javaType.valueFrom(),
            )
    }
}
