@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerPath The absolute file path in the container where the tmpfs volume is mounted.
 * @property readOnly If this value is true, the container has read-only access to the volume.
 * @property sourceVolume The name of the volume to mount.
 */
public data class GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPoint(
    public val containerPath: String,
    public val readOnly: Boolean,
    public val sourceVolume: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPoint): GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPoint =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPoint(
                containerPath = javaType.containerPath(),
                readOnly = javaType.readOnly(),
                sourceVolume = javaType.sourceVolume(),
            )
    }
}
