@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hardLimit The hard limit for the ulimit type.
 * @property name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
 * @property softLimit The soft limit for the ulimit type.
 */
public data class GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimit(
    public val hardLimit: Int,
    public val name: String,
    public val softLimit: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimit): GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimit =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimit(
                hardLimit = javaType.hardLimit(),
                name = javaType.name(),
                softLimit = javaType.softLimit(),
            )
    }
}
