@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property efsVolumeConfigurations This parameter is specified when you're using an Amazon Elastic File System file system for job storage.
 * @property hosts The contents of the host parameter determine whether your data volume persists on the host container instance and where it's stored.
 * @property name The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
 */
public data class GetJobDefinitionNodePropertyNodeRangePropertyContainerVolume(
    public val efsVolumeConfigurations: List<GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfiguration>,
    public val hosts: List<GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeHost>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolume): GetJobDefinitionNodePropertyNodeRangePropertyContainerVolume =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerVolume(
                efsVolumeConfigurations = javaType.efsVolumeConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfiguration.Companion.toKotlin(args0)
                    })
                }),
                hosts = javaType.hosts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeHost.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
            )
    }
}
