@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authorizationConfigs The authorization configuration details for the Amazon EFS file system.
 * @property fileSystemId The Amazon EFS file system ID to use.
 * @property rootDirectory The directory within the Amazon EFS file system to mount as the root directory inside the host.
 * @property transitEncryption Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server
 * @property transitEncryptionPort The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
 */
public data class
GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfiguration(
    public val authorizationConfigs: List<GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationAuthorizationConfig>,
    public val fileSystemId: String,
    public val rootDirectory: String,
    public val transitEncryption: String,
    public val transitEncryptionPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfiguration): GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfiguration =
            GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfiguration(
                authorizationConfigs = javaType.authorizationConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationAuthorizationConfig.Companion.toKotlin(args0)
                    })
                }),
                fileSystemId = javaType.fileSystemId(),
                rootDirectory = javaType.rootDirectory(),
                transitEncryption = javaType.transitEncryption(),
                transitEncryptionPort = javaType.transitEncryptionPort(),
            )
    }
}
