@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attempts The number of times to move a job to the RUNNABLE status.
 * @property evaluateOnExits Array of up to 5 objects that specify the conditions where jobs are retried or failed.
 */
public data class GetJobDefinitionRetryStrategy(
    public val attempts: Int,
    public val evaluateOnExits: List<GetJobDefinitionRetryStrategyEvaluateOnExit>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionRetryStrategy): GetJobDefinitionRetryStrategy = GetJobDefinitionRetryStrategy(
            attempts = javaType.attempts(),
            evaluateOnExits = javaType.evaluateOnExits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetJobDefinitionRetryStrategyEvaluateOnExit.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
