@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Specifies the action to take if all of the specified conditions (onStatusReason, onReason, and onExitCode) are met. The values aren't case sensitive.
 * @property onExitCode Contains a glob pattern to match against the decimal representation of the ExitCode returned for a job.
 * @property onReason Contains a glob pattern to match against the Reason returned for a job.
 * @property onStatusReason Contains a glob pattern to match against the StatusReason returned for a job.
 */
public data class GetJobDefinitionRetryStrategyEvaluateOnExit(
    public val action: String,
    public val onExitCode: String,
    public val onReason: String,
    public val onStatusReason: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobDefinitionRetryStrategyEvaluateOnExit): GetJobDefinitionRetryStrategyEvaluateOnExit = GetJobDefinitionRetryStrategyEvaluateOnExit(
            action = javaType.action(),
            onExitCode = javaType.onExitCode(),
            onReason = javaType.onReason(),
            onStatusReason = javaType.onStatusReason(),
        )
    }
}
